/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import org.netbeans.apitest.ClassCollection;
import org.netbeans.apitest.ClassConstants;
import org.netbeans.apitest.DefinitionFormat;

class PrimitiveConstantsChecker
extends DefinitionFormat
implements ClassConstants {
    private ClassCollection primitiveConstants = new ClassCollection();
    String ClassName = "N/A";
    private DataInputStream in;
    private byte[] types;
    private Object[] cpool;

    public PrimitiveConstantsChecker(boolean isQualifiedName, boolean isThrowsTracked) {
        super(isQualifiedName, isThrowsTracked, new Properties());
    }

    public PrimitiveConstantsChecker(boolean isQualifiedName, boolean isThrowsTracked, String[][] removedModif) {
        super(isQualifiedName, isThrowsTracked, removedModif);
    }

    public String getDefinition(String definition) {
        if (definition.startsWith("fld  ") && this.isQualifiedName && this.isPrimitiveConstant(definition) && !definition.startsWith("fld  constant ")) {
            return super.getDefinition("fld  constant " + definition.substring("fld  ".length()));
        }
        return super.getDefinition(definition);
    }

    public void checkPrimitiveConstants(String className, InputStream inClass) throws IOException {
        this.in = new DataInputStream(inClass);
        this.ClassName = "N/A";
        Vector fieldNames = null;
        int magic = this.in.readInt();
        int min_version = this.in.readUnsignedShort();
        int version = this.in.readUnsignedShort();
        this.readConstantPool();
        short access = this.in.readShort();
        int this_cpx = this.in.readUnsignedShort();
        try {
            this.ClassName = (String)this.cpool[(Integer)this.cpool[this_cpx]];
        }
        catch (Exception e) {
            // empty catch block
        }
        int super_cpx = this.in.readUnsignedShort();
        int numinterfaces = this.in.readUnsignedShort();
        this.in.skipBytes(numinterfaces * 2);
        fieldNames = this.decodeMembers();
        this.in.close();
        inClass.close();
        this.primitiveConstants.putVector(className, fieldNames);
    }

    public boolean isPrimitiveConstant(String def) {
        if (def.startsWith("fld  ")) {
            String name = def.substring(def.lastIndexOf(32) + 1);
            int pos = name.lastIndexOf(46);
            String className = pos >= 0 ? name.substring(0, pos) : name;
            Vector<Object> h = this.primitiveConstants.get(className);
            if (h != null && h.contains(name.substring(name.lastIndexOf(46) + 1))) {
                return true;
            }
            pos = def.lastIndexOf(32) - 1;
            pos = def.lastIndexOf(32) - 1;
            return def.lastIndexOf(" constant", pos) >= 0;
        }
        return false;
    }

    private void readConstantPool() throws IOException {
        int length;
        int CPlen = length = this.in.readUnsignedShort();
        this.types = new byte[length];
        this.cpool = new Object[length];
        block9: for (int i = 1; i < length; ++i) {
            byte tag;
            int n = i;
            this.types[i] = tag = this.in.readByte();
            switch (this.types[i]) {
                case 1: {
                    this.cpool[i] = this.in.readUTF();
                    continue block9;
                }
                case 3: {
                    int v1 = this.in.readInt();
                    this.cpool[i] = new Integer(v1);
                    continue block9;
                }
                case 4: {
                    int v1 = Float.floatToIntBits(this.in.readFloat());
                    this.cpool[i] = new Integer(v1);
                    continue block9;
                }
                case 5: {
                    long lv = this.in.readLong();
                    this.cpool[i] = new Long(lv);
                    ++i;
                    continue block9;
                }
                case 6: {
                    long lv = Double.doubleToLongBits(this.in.readDouble());
                    this.cpool[i] = new Long(lv);
                    ++i;
                    continue block9;
                }
                case 7: 
                case 8: {
                    int v1 = this.in.readUnsignedShort();
                    this.cpool[i] = new Integer(v1);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[i] = "#" + this.in.readUnsignedShort() + " #" + this.in.readUnsignedShort();
                    continue block9;
                }
                default: {
                    CPlen = i;
                    throw new ClassFormatError();
                }
            }
        }
    }

    private Vector decodeMembers() throws IOException {
        Vector<Object> retVal = new Vector<Object>();
        int nfields = this.in.readUnsignedShort();
        boolean isPrimitiveConstant = false;
        for (int i = 0; i < nfields; ++i) {
            short access = this.in.readShort();
            isPrimitiveConstant = ((access & 1) != 0 || (access & 4) != 0) && (access & 8) != 0 && (access & 0x10) != 0;
            int name_cpx = this.in.readUnsignedShort();
            int sig_cpx = this.in.readUnsignedShort();
            if (!this.decodeAttributes() || !isPrimitiveConstant) continue;
            retVal.addElement(this.cpool[name_cpx]);
        }
        return retVal;
    }

    private boolean decodeAttributes() throws IOException {
        boolean hasValue = false;
        int attr_num = this.in.readUnsignedShort();
        for (int i = 0; i < attr_num; ++i) {
            if (!this.decodeAttribute()) continue;
            hasValue = true;
        }
        return hasValue;
    }

    private boolean decodeAttribute() throws IOException {
        int name_cpx = this.in.readUnsignedShort();
        String AttrName = "";
        try {
            byte tag = this.types[name_cpx];
            if (tag == 1) {
                AttrName = (String)this.cpool[name_cpx];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        int len = this.in.readInt();
        byte[] attr = new byte[len];
        this.in.read(attr);
        return AttrName.equals("ConstantValue");
    }
}

