/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import org.netbeans.apitest.ErrorFormatter;

final class ErrorMessage {
    String[] messages;
    String className;
    String definition;
    String tail;
    int errorType;

    public ErrorMessage(int errorType, String className, String definition, String tail) {
        this.errorType = errorType;
        this.className = className;
        this.definition = definition == null ? "" : definition;
        this.tail = tail == null ? "" : tail;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }

    public int compareTo(ErrorMessage ob) {
        if (ob.errorType == this.errorType) {
            if (this.className.equals(ob.className)) {
                return this.getShortName(this.definition).compareTo(this.getShortName(ob.definition));
            }
            return this.className.compareTo(ob.className);
        }
        return this.errorType - ob.errorType;
    }

    public String getShortName(String def) {
        int pos = def.lastIndexOf(" throws ");
        String retVal = pos >= 0 ? def.substring(0, pos) : def;
        return retVal.substring(retVal.lastIndexOf(32) + 1);
    }

    public String toString() {
        return this.messages[this.errorType] + this.className + "\n    " + ErrorFormatter.toString(this.definition) + this.tail;
    }
}

