/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.util.Properties;
import org.netbeans.apitest.SignatureConstants;

class DefinitionFormat
implements SignatureConstants {
    protected boolean isQualifiedName;
    protected boolean isThrowsTracked;
    protected String[][] removedModifiers;

    public DefinitionFormat(boolean isQualifiedName, boolean isThrowsTracked, Properties details) {
        this.isQualifiedName = isQualifiedName;
        this.isThrowsTracked = isThrowsTracked;
        String[] classModif = null;
        if (details.getProperty("NestedProtected") != null) {
            classModif = details.getProperty("NestedStatic") != null ? new String[]{"CLSS ", "flag_super", "protected", "static"} : new String[]{"CLSS ", "flag_super", "protected"};
        } else if (details.getProperty("NestedStatic") != null) {
            classModif = new String[]{"CLSS ", "flag_super", "static"};
        }
        if (!isQualifiedName) {
            String[][] temp = new String[][]{{"fld  ", "transient", "constant"}, {"cons ", "synchronized", "native"}, {"meth ", "synchronized", "native"}, {"CLSS ", "flag_super"}, {"innr ", "flag_super", "synchronized"}};
            if (classModif != null) {
                temp[3] = classModif;
                temp[4] = (String[])classModif.clone();
                temp[4][0] = "innr ";
            }
            this.removedModifiers = temp;
        } else {
            this.removedModifiers = new String[0][0];
            if (classModif != null) {
                this.removedModifiers = new String[][]{classModif, (String[])classModif.clone()};
                this.removedModifiers[1][0] = "innr ";
            }
        }
    }

    public DefinitionFormat(boolean isQualifiedName, boolean isThrowsTracked, String[][] removedModif) {
        this.isQualifiedName = isQualifiedName;
        this.isThrowsTracked = isThrowsTracked;
        this.removedModifiers = removedModif == null ? new String[0][0] : removedModif;
    }

    public String getDefinition(String definition) {
        int pos;
        String retVal = definition;
        if (!this.isThrowsTracked && (pos = definition.lastIndexOf(" throws ")) >= 0) {
            retVal = definition.substring(0, pos);
        }
        for (int j = 0; j < this.removedModifiers.length; ++j) {
            if (!retVal.startsWith(this.removedModifiers[j][0])) continue;
            for (int i = 1; i < this.removedModifiers[j].length; ++i) {
                retVal = DefinitionFormat.removeModifier(this.removedModifiers[j][i], retVal);
            }
        }
        return retVal;
    }

    public boolean isQualifiedNamesUsed() {
        return this.isQualifiedName;
    }

    private static String removeWord(String word, String mes) {
        if (mes.indexOf(" " + word + " ") >= 0) {
            int n = mes.indexOf(" " + word + " ");
            return mes.substring(0, n) + mes.substring(n + word.length() + 1);
        }
        if (mes.endsWith(" " + word)) {
            return mes.substring(0, mes.lastIndexOf(" " + word));
        }
        if (mes.startsWith(word + " ")) {
            return mes.substring(word.length() + 1);
        }
        return mes;
    }

    public static String removeModifier(String word, String mes) {
        int pos = mes.lastIndexOf(" throws ");
        pos = pos < 0 ? mes.lastIndexOf(32) : mes.lastIndexOf(32, pos - 1);
        pos = pos < 0 ? 0 : pos;
        return DefinitionFormat.removeWord(word, mes.substring(0, pos)) + mes.substring(pos);
    }
}

