/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.impl;

import com.sun.jbi.workflow.model.ModelElement;
import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.Notification;
import com.sun.jbi.workflow.model.PartnerLinkType;
import com.sun.jbi.workflow.model.PartnerLinkTypeRole;
import com.sun.jbi.workflow.model.Task;
import com.sun.jbi.workflow.model.Tasks;
import com.sun.jbi.workflow.model.WSDLDefinition;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public class Util {
    public static Notification findNotification(QName qname, ModelElement element) {
        Notification notification = null;
        Task task = Util.findTaskAncestor(element);
        if (task != null) {
            notification = task.getNotification(qname);
        }
        return notification;
    }

    public static Task findTaskAncestor(ModelElement element) {
        Task task = null;
        if (element != null) {
            for (ModelElement el = element; el != null; el = el.getParent()) {
                if (!(el instanceof Task)) continue;
                task = (Task)el;
                break;
            }
        }
        return task;
    }

    public static Tasks findTasksAncestor(ModelElement element) {
        Tasks tasks = null;
        if (element != null) {
            for (ModelElement el = element; el != null; el = el.getParent()) {
                if (!(el instanceof Tasks)) continue;
                tasks = (Tasks)el;
                break;
            }
        }
        return tasks;
    }

    public static Operation getWSDLOperation(QName operationQName, ModelElement element) throws ModelException {
        Operation operation = null;
        if (operationQName == null) {
            return null;
        }
        Tasks tasks = Util.findTasksAncestor(element);
        if (tasks == null) {
            return null;
        }
        List allImports = tasks.getImportWSDLs();
        if (allImports != null && allImports.size() > 0) {
            for (int i = 0; i < allImports.size(); ++i) {
                WSDLDefinition wsdlDef = (WSDLDefinition)allImports.get(i);
                Collection col = wsdlDef.getPortTypes().values();
                block1: for (PortType portType : col) {
                    List optList;
                    if (!portType.getQName().getNamespaceURI().equals(operationQName.getNamespaceURI()) || (optList = portType.getOperations()) == null || optList.size() <= 0) continue;
                    for (int j = 0; j < optList.size(); ++j) {
                        Operation opt = (Operation)optList.get(j);
                        if (!opt.getName().equals(operationQName.getLocalPart())) continue;
                        operation = opt;
                        continue block1;
                    }
                }
            }
        }
        return operation;
    }

    public static PartnerLinkType getWSDLPartnerLinkType(QName partnerLinkTypeQName, ModelElement element) throws ModelException {
        PartnerLinkType partnerLinkType = null;
        if (partnerLinkTypeQName == null) {
            return null;
        }
        Tasks tasks = Util.findTasksAncestor(element);
        if (tasks == null) {
            return null;
        }
        List allImports = tasks.getImportWSDLs();
        if (allImports != null && allImports.size() > 0) {
            for (int i = 0; i < allImports.size(); ++i) {
                WSDLDefinition wsdlDef = (WSDLDefinition)allImports.get(i);
                Map partnerLinkMap = wsdlDef.getPartnerLinkTypes();
                if (partnerLinkMap == null || partnerLinkMap.size() <= 0 || !partnerLinkMap.containsKey(partnerLinkTypeQName.getLocalPart())) continue;
                partnerLinkType = (PartnerLinkType)partnerLinkMap.get(partnerLinkTypeQName.getLocalPart());
                break;
            }
        }
        return partnerLinkType;
    }

    public static PortType getPortType(QName partnerLinkTypeQName, String roleName, ModelElement element) throws ModelException {
        List roles;
        PartnerLinkType partnerLinkType = Util.getWSDLPartnerLinkType(partnerLinkTypeQName, element);
        if (partnerLinkType != null && (roles = partnerLinkType.getRoles()) != null && roles.size() > 0) {
            for (int i = 0; i < roles.size(); ++i) {
                PartnerLinkTypeRole role = (PartnerLinkTypeRole)roles.get(i);
                if (!role.getName().equals(roleName)) continue;
                return role.getWSDLPortType();
            }
        }
        return null;
    }

    public static String getTargetNamesapce(ModelElement element) {
        String ns = null;
        Tasks tasks = Util.findTasksAncestor(element);
        if (tasks != null) {
            ns = tasks.getTargetNamespace();
        }
        return ns;
    }
}

