/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractIntCollection;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;

public abstract class RandomAccessIntList
extends AbstractIntCollection
implements IntList {
    private int _modCount = 0;

    protected RandomAccessIntList() {
    }

    public abstract int get(int var1);

    public abstract int size();

    public int removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    public int set(int index, int element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, int element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(int element) {
        this.add(this.size(), element);
        return true;
    }

    public boolean addAll(int index, IntCollection collection) {
        boolean modified = false;
        IntIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    public int indexOf(int element) {
        int i = 0;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        IntListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    public IntIterator iterator() {
        return this.listIterator();
    }

    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    public IntListIterator listIterator(int index) {
        return new RandomAccessIntListIterator(this, index);
    }

    public IntList subList(int fromIndex, int toIndex) {
        return new RandomAccessIntSubList(this, fromIndex, toIndex);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof IntList) {
            IntList thatList = (IntList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            IntIterator thatIter = thatList.iterator();
            IntIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            hash = 31 * hash + iter.next();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessIntSubList
    extends RandomAccessIntList
    implements IntList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessIntList _list = null;
        private ComodChecker _comod = null;

        RandomAccessIntSubList(RandomAccessIntList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        public int get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        public int removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            int val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        public int set(int index, int element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            int val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        public void add(int index, int element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }

    protected static class RandomAccessIntListIterator
    extends ComodChecker
    implements IntListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessIntListIterator(RandomAccessIntList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        public int next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        public int previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            int val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        public void add(int value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        public void set(int value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessIntList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessIntList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessIntList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

