/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoObject;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class JGoUndoManager
extends UndoManager
implements JGoDocumentListener {
    public String[] myViewEditPresentationNames = new String[]{"", "Move Selection", "Copy Selection", "Resize", "New Link", "ReLink", "Drop", "Edit Text", "Copy", "Cut", "Paste", "Delete Selection", "Scrollbar", "No ReLink", "Undo", "Redo"};
    private boolean myUndoing = false;
    private boolean myRedoing = false;
    private JGoCompoundEdit myCompoundEdit = null;
    private int myLevel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() throws CannotUndoException {
        try {
            this.myUndoing = true;
            this.endTransaction(true, null);
            super.undo();
        }
        finally {
            this.myUndoing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() throws CannotRedoException {
        try {
            this.myRedoing = true;
            this.endTransaction(false, null);
            super.redo();
        }
        finally {
            this.myRedoing = false;
        }
    }

    public void discardAllEdits() {
        this.endTransaction(false, null);
        super.discardAllEdits();
    }

    public void documentChanged(JGoDocumentEvent e) {
        if (this.isUndoing() || this.isRedoing()) {
            return;
        }
        if (!this.skipEvent(e)) {
            JGoCompoundEdit cedit = this.getCurrentEdit();
            if (cedit == null) {
                cedit = new JGoCompoundEdit();
                this.setCurrentEdit(cedit);
            }
            JGoDocumentChangedEdit edit = new JGoDocumentChangedEdit(e, this, e.isBeforeChanging());
            cedit.addEdit(edit);
        }
    }

    public boolean skipEvent(JGoDocumentEvent e) {
        if (e.getHint() < 200) {
            return true;
        }
        Object src = e.getSource();
        if (src == null || !(src instanceof JGoDocument)) {
            return true;
        }
        JGoDocument doc = (JGoDocument)src;
        if (doc.isSkipsUndoManager()) {
            return true;
        }
        if (e.getHint() == 203) {
            if (e.getFlags() == 0) {
                return true;
            }
            JGoObject obj = e.getJGoObject();
            if (obj == null || obj.isSkipsUndoManager()) {
                return true;
            }
        }
        return false;
    }

    public int getTransactionLevel() {
        return this.myLevel;
    }

    public void startTransaction() {
        ++this.myLevel;
    }

    public void endTransaction(boolean commit) {
        this.endTransaction(commit, null);
    }

    public void endTransaction(String pname) {
        this.endTransaction(true, pname);
    }

    void endTransaction(boolean commit, String pname) {
        if (this.myLevel > 0) {
            --this.myLevel;
        }
        if (this.myLevel == 0 && this.myCompoundEdit != null) {
            if (commit) {
                this.myCompoundEdit.end();
                if (this.myCompoundEdit.getAllEdits().size() > 0) {
                    if (pname != null) {
                        this.myCompoundEdit.setPresentationName(pname);
                    }
                    this.addEdit(this.myCompoundEdit);
                }
            } else {
                this.myCompoundEdit.die();
            }
            this.myCompoundEdit = null;
        }
    }

    public Vector getAllEdits() {
        return this.edits;
    }

    public Vector getCurrentEditVector() {
        if (this.getCurrentEdit() != null) {
            return this.getCurrentEdit().getAllEdits();
        }
        return null;
    }

    public JGoCompoundEdit getCurrentEdit() {
        return this.myCompoundEdit;
    }

    public void setCurrentEdit(JGoCompoundEdit e) {
        this.myCompoundEdit = e;
    }

    UndoableEdit getEditToUndo() {
        return this.editToBeUndone();
    }

    UndoableEdit getEditToRedo() {
        return this.editToBeRedone();
    }

    public boolean isUndoing() {
        return this.myUndoing;
    }

    public boolean isRedoing() {
        return this.myRedoing;
    }

    public String getViewEditPresentationName(int act) {
        if (act >= 0 && act < this.myViewEditPresentationNames.length) {
            return this.myViewEditPresentationNames[act];
        }
        return null;
    }

    public class JGoCompoundEdit
    extends CompoundEdit {
        private String myName = "";

        public Vector getAllEdits() {
            return this.edits;
        }

        public String getPresentationName() {
            return this.myName;
        }

        public void setPresentationName(String s) {
            this.myName = s;
        }

        public String getUndoPresentationName() {
            return JGoUndoManager.this.getViewEditPresentationName(14) + " " + this.getPresentationName();
        }

        public String getRedoPresentationName() {
            return JGoUndoManager.this.getViewEditPresentationName(15) + " " + this.getPresentationName();
        }
    }
}

