/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class JGoPolygon
extends JGoStroke {
    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoPolygon newobj = (JGoPolygon)super.copyObject(env);
        if (newobj != null) {
            // empty if block
        }
        return newobj;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoPolygon = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoPolygon", jGoElementGroup);
        }
        if (svgDoc.SVGOutputEnabled()) {
            DomElement path = svgDoc.createElement("path");
            String pathArgs = "";
            int length = this.myPoints.size();
            if (length > 0) {
                Point point = (Point)this.myPoints.get(0);
                pathArgs = pathArgs + "M";
                pathArgs = pathArgs + " " + Integer.toString(point.x);
                pathArgs = pathArgs + " " + Integer.toString(point.y);
                for (int i = 1; i < this.myPoints.size(); ++i) {
                    point = (Point)this.myPoints.get(i);
                    pathArgs = pathArgs + " L " + Integer.toString(point.x);
                    pathArgs = pathArgs + " " + Integer.toString(point.y);
                }
                pathArgs = pathArgs + " Z";
                this.SVGWriteAttributes(path);
                path.setAttribute("d", pathArgs);
                jGoElementGroup.appendChild(path);
            }
        }
        svgDoc.setDisabledDrawing(true);
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void paint(Graphics2D g, JGoView view) {
        int npoints = this.getNumPoints();
        if (npoints <= 1) {
            return;
        }
        GeneralPath path = this.getPath(view);
        JGoPen highlight = this.getHighlight();
        if (highlight != null) {
            JGoPolygon.drawPath(g, highlight, null, path);
        }
        JGoPolygon.drawPath(g, this.getPen(), this.getBrush(), path);
    }

    public boolean isPointInObj(Point pnt) {
        int line_width;
        Rectangle rect = this.getBoundingRect();
        int n = line_width = this.getPen() != null ? this.getPen().getWidth() : 1;
        if (pnt.x < rect.x - line_width || pnt.x > rect.x + rect.width + line_width || pnt.y < rect.y - line_width || pnt.y > rect.y + rect.height + line_width) {
            return false;
        }
        int npoints = this.getNumPoints();
        if (npoints <= 1) {
            return false;
        }
        GeneralPath poly = this.getPath(null);
        return poly.contains(pnt.x, pnt.y);
    }

    void makePath(GeneralPath path, JGoView view) {
        super.makePath(path, view);
        path.closePath();
    }
}

