/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;

public class Utils {
    public static void copyFile(File file, File target) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[10240];
            int len = 0;
            while ((len = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bis.close();
            bos.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void copyFolder(File folder, File target) {
        File[] lst = folder.listFiles();
        if (!target.exists()) {
            target.mkdirs();
        }
        for (int i = 0; i < lst.length; ++i) {
            File nw = new File(target, lst[i].getName());
            if (lst[i].isDirectory()) {
                Utils.copyFolder(lst[i], nw);
                continue;
            }
            Utils.copyFile(lst[i], nw);
        }
    }

    public static ProfilingEventListener createProfilingListener(final CommonProfilerTestCase test) {
        return new ProfilingEventListener(){

            public void targetAppStarted() {
                test.log("app started");
                test.setStatus(1);
            }

            public void targetAppStopped() {
                test.log("app stoped");
            }

            public void targetAppSuspended() {
                test.log("app suspended");
            }

            public void targetAppResumed() {
                test.log("app resumed");
            }

            public void attachedToTarget() {
                test.log("app attached to target");
            }

            public void detachedFromTarget() {
                test.log("app detached from target");
            }

            public void targetVMTerminated() {
                test.log("vm terminated");
                test.setStatus(16);
            }
        };
    }

    public static void removeFolder(File folder) {
        File[] lst = folder.listFiles();
        if (lst == null) {
            System.err.println("null files " + folder.getAbsolutePath());
            return;
        }
        for (int i = 0; i < lst.length; ++i) {
            if (lst[i].isDirectory()) {
                Utils.removeFolder(lst[i]);
                continue;
            }
            lst[i].delete();
        }
        folder.delete();
    }
}

