/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.cpu;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.tests.jfluid.cpu.CPUTestCase;

public class BasicTest
extends CPUTestCase {
    private static final long MAX_DELAY = 25000L;

    public BasicTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BasicTest.class);
        return suite;
    }

    public void temptestSettingsInstrumentRootMethod(boolean server) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1", new String[][]{{"simple.cpu.CPUThread", "run", "()V"}});
        settings.setInstrumentSpawnedThreads(false);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(true);
        settings.setInstrumentEmptyMethods(true);
        settings.setInstrScheme(1);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        this.startCPUTest(settings, new String[]{"simple.cpu.CPUThread.run512()"}, new long[]{512L}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }

    public void testLiveResultsAll() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        this.startCPUTest(settings, new String[]{""}, 1000L, 25000L);
    }

    public void testLiveResultsBasic() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.CPU");
        this.startCPUTest(settings, new String[]{"simple"}, 1500L, 25000L);
    }

    public void testLiveResultsWaitEager() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.WaitingTest");
        settings.setInstrScheme(2);
        this.startCPUTest(settings, new String[]{"simple"}, 1000L, 25000L);
    }

    public void testLiveResultsWaitLazy() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.WaitingTest");
        settings.setInstrScheme(1);
        this.startCPUTest(settings, new String[]{"simple"}, 1000L, 25000L);
    }

    public void testLiveResultsWaitSampled() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.WaitingTest");
        settings.setCPUProfilingType(1);
        settings.setSamplingInterval(1);
        this.startCPUTest(settings, new String[]{"simple"}, 1000L, 25000L);
    }

    public void testLiveResultsWaitServer() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.WaitingTest");
        this.addJVMArgs(settings, "-server");
        this.startCPUTest(settings, new String[]{"simple"}, 1000L, 25000L);
    }

    public void testLiveResultsWaitTotal() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.WaitingTest");
        settings.setInstrScheme(3);
        this.startCPUTest(settings, new String[]{"simple"}, 1000L, 25000L);
    }

    public void testMethodWithWaitEager() {
        this.temptestMethodWithWait(2, false, false, 2000L);
    }

    public void testMethodWithWaitEagerServer() {
        this.temptestMethodWithWait(2, false, true, 2000L);
    }

    public void testMethodWithWaitExcludeWEager() {
        this.temptestMethodWithWait(2, true, false, 4000L);
    }

    public void testMethodWithWaitExcludeWLazy() {
        this.temptestMethodWithWait(1, true, false, 4000L);
    }

    public void testMethodWithWaitExcludeWTotal() {
        this.temptestMethodWithWait(3, true, false, 4000L);
    }

    public void testMethodWithWaitLazy() {
        this.temptestMethodWithWait(1, false, false, 2000L);
    }

    public void testMethodWithWaitLazyServer() {
        this.temptestMethodWithWait(1, false, true, 2000L);
    }

    public void testMethodWithWaitTotal() {
        this.temptestMethodWithWait(3, false, false, 2000L);
    }

    public void testMethodWithWaitTotalServer() {
        this.temptestMethodWithWait(3, false, true, 2000L);
    }

    public void testSettingsDefault() {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        this.startCPUTest(settings, new String[]{"simple.cpu.Bean.run20()", "simple.cpu.Bean.run100()", "simple.cpu.Bean.run1000()", "simple.cpu.CPUThread.run512()"}, new long[]{20L, 100L, 1000L, 512L}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }

    public void testSettingsInstrumenManyMethodsLazy() {
        this.temptestSettingsInstrumentManyMethods(1);
    }

    public void testSettingsInstrumentAllEager() {
        this.temptestSettingsInstrumentAll(2, false);
    }

    public void testSettingsInstrumentAllEagerServer() {
        this.temptestSettingsInstrumentAll(2, true);
    }

    public void testSettingsInstrumentAllLazy() {
        this.temptestSettingsInstrumentAll(1, false);
    }

    public void testSettingsInstrumentAllLazyServer() {
        this.temptestSettingsInstrumentAll(1, true);
    }

    public void testSettingsInstrumentAllTotal() {
        this.temptestSettingsInstrumentAll(3, false);
    }

    public void testSettingsInstrumentAllTotalServer() {
        this.temptestSettingsInstrumentAll(3, true);
    }

    public void testSettingsInstrumentExcludeJavas() {
        this.temptestSettingsInstrumentExcludeJavas(false);
    }

    public void testSettingsInstrumentExcludeJavasServer() {
        this.temptestSettingsInstrumentExcludeJavas(true);
    }

    public void testSettingsInstrumentManyMethodsTotal() {
        this.temptestSettingsInstrumentManyMethods(3);
    }

    public void testSettingsInstrumentNotSpawnedThreads() {
        this.temptestSettingsInstrumentNotSpawnedThreads(false);
    }

    public void testSettingsInstrumentNotSpawnedThreadsServer() {
        this.temptestSettingsInstrumentNotSpawnedThreads(true);
    }

    public void testSettingsInstrumentRootMethod() {
        this.temptestSettingsInstrumentRootMethod(false);
    }

    public void testSettingsInstrumentRootMethodServer() {
        this.temptestSettingsInstrumentRootMethod(true);
    }

    public void testSettingsLimitedThreads() {
        this.temptestSettingsLimitedThreads(false);
    }

    public void testSettingsLimitedThreadsServer() {
        this.temptestSettingsLimitedThreads(true);
    }

    public void testSettingsSampledProfilingEager() {
        this.temptestSettingsSampledProfiling(false, 2);
    }

    public void testSettingsSampledProfilingLazy() {
        this.temptestSettingsSampledProfiling(false, 1);
    }

    public void testSettingsSampledProfilingServerEager() {
        this.temptestSettingsSampledProfiling(true, 2);
    }

    public void testSettingsSampledProfilingServerLazy() {
        this.temptestSettingsSampledProfiling(true, 1);
    }

    public void testSettingsSampledProfilingServerTotal() {
        this.temptestSettingsSampledProfiling(true, 3);
    }

    public void testSettingsSampledProfilingTotal() {
        this.temptestSettingsSampledProfiling(false, 3);
    }

    protected void temptestMethodWithWait(int instrscheme, boolean withwaits, boolean server, long idealtime) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.WaitingTest", new String[][]{{"simple.cpu.WaitingTest", "method1000", "()V"}});
        settings.setInstrScheme(instrscheme);
        settings.setExcludeWaitTime(!withwaits);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        this.startCPUTest(settings, new String[]{"simple.cpu.WaitingTest.method1000()"}, new long[]{idealtime}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }

    protected void temptestSettingsInstrumentAll(int instrScheme, boolean server) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        settings.setInstrumentSpawnedThreads(true);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(true);
        settings.setInstrumentEmptyMethods(true);
        settings.setInstrScheme(instrScheme);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        this.startCPUTest(settings, new String[]{"simple.cpu.Bean.run20()", "simple.cpu.Bean.run100()", "simple.cpu.Bean.run1000()", "simple.cpu.CPUThread.run512()"}, new long[]{20L, 100L, 1000L, 512L}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }

    protected void temptestSettingsInstrumentExcludeJavas(boolean server) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        settings.setInstrumentSpawnedThreads(true);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(false);
        settings.setInstrumentEmptyMethods(false);
        settings.setInstrScheme(1);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        InstrumentationFilter filter = new InstrumentationFilter();
        filter.setFilterType(10);
        filter.setFilterStrings("java");
        settings.setInstrumentationFilter(filter);
        this.startCPUTest(settings, new String[]{"simple.cpu.Bean.run20()", "simple.cpu.Bean.run100()", "simple.cpu.Bean.run1000()", "simple.cpu.CPUThread.run512()"}, new long[]{20L, 100L, 1000L, 512L}, 40.0, new String[]{"simple", "java"}, ALL_INV_ERROR_METHOD);
    }

    protected void temptestSettingsInstrumentManyMethods(int instrscheme) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.Methods2");
        settings.setInstrumentSpawnedThreads(true);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(true);
        settings.setInstrumentEmptyMethods(true);
        settings.setInstrScheme(instrscheme);
        this.startCPUTest(settings, new String[]{"simple.cpu.Methods2.method0()"}, new long[]{400L}, 40.0, new String[]{"simple.cpu.Methods2.method1"}, ALL_INV_ERROR_METHOD);
    }

    protected void temptestSettingsInstrumentNotSpawnedThreads(boolean server) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        settings.setInstrumentSpawnedThreads(false);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(true);
        settings.setInstrumentEmptyMethods(true);
        settings.setInstrScheme(1);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        this.startCPUTest(settings, new String[]{"simple.cpu.Bean.run20()", "simple.cpu.Bean.run100()", "simple.cpu.Bean.run1000()", "simple.cpu.CPUThread.run512()"}, new long[]{20L, 100L, 1000L, 512L}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }

    protected void temptestSettingsLimitedThreads(boolean server) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        settings.setInstrumentSpawnedThreads(true);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(true);
        settings.setInstrumentEmptyMethods(true);
        settings.setNProfiledThreadsLimit(1);
        settings.setInstrScheme(1);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        this.startCPUTest(settings, new String[]{"simple.cpu.Bean.run20()", "simple.cpu.Bean.run100()", "simple.cpu.Bean.run1000()", "simple.cpu.CPUThread.run512()"}, new long[]{20L, 100L, 1000L, 512L}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }

    protected void temptestSettingsSampledProfiling(boolean server, int instrScheme) {
        ProfilerEngineSettings settings = this.initCpuTest("j2se-simple", "simple.cpu.CPU1");
        settings.setInstrumentSpawnedThreads(true);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentGetterSetterMethods(true);
        settings.setInstrumentEmptyMethods(true);
        settings.setCPUProfilingType(1);
        settings.setSamplingInterval(5);
        settings.setInstrScheme(instrScheme);
        if (server) {
            this.addJVMArgs(settings, "-server");
        }
        this.startCPUTest(settings, new String[]{"simple.cpu.Bean.run20()", "simple.cpu.Bean.run100()", "simple.cpu.Bean.run1000()", "simple.cpu.CPUThread.run512()"}, new long[]{20L, 100L, 1000L, 512L}, 40.0, new String[]{"simple"}, ALL_INV_ERROR_METHOD);
    }
}

