/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.XComponent;
import net.fortuna.ical4j.util.CompatibilityHints;

public final class ComponentFactory {
    private static ComponentFactory instance = new ComponentFactory();
    private boolean allowIllegalNames = CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed");

    private ComponentFactory() {
    }

    public static ComponentFactory getInstance() {
        return instance;
    }

    public Component createComponent(String name) {
        return this.createComponent(name, new PropertyList());
    }

    public Component createComponent(String name, PropertyList properties) {
        if ("VALARM".equals(name)) {
            return new VAlarm(properties);
        }
        if ("VEVENT".equals(name)) {
            return new VEvent(properties);
        }
        if ("VFREEBUSY".equals(name)) {
            return new VFreeBusy(properties);
        }
        if ("VJOURNAL".equals(name)) {
            return new VJournal(properties);
        }
        if ("VTODO".equals(name)) {
            return new VToDo(properties);
        }
        if ("STANDARD".equals(name)) {
            return new Standard(properties);
        }
        if ("DAYLIGHT".equals(name)) {
            return new Daylight(properties);
        }
        if ("VTIMEZONE".equals(name)) {
            return new VTimeZone(properties);
        }
        if (this.isExperimentalName(name)) {
            return new XComponent(name, properties);
        }
        if (this.allowIllegalNames) {
            return new XComponent(name, properties);
        }
        throw new IllegalArgumentException("Illegal component [" + name + "]");
    }

    public Component createComponent(String name, PropertyList properties, ComponentList components) {
        if (components != null) {
            if ("VTIMEZONE".equals(name)) {
                return new VTimeZone(properties, components);
            }
            if ("VEVENT".equals(name)) {
                return new VEvent(properties, components);
            }
            throw new IllegalArgumentException("Illegal component [" + name + "]");
        }
        return this.createComponent(name, properties);
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith("X-") && name.length() > "X-".length();
    }
}

