/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.header.HeaderInfo;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

final class RegexpHeaderInfo
extends HeaderInfo {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private Pattern[] mHeaderRegexps;
    private int[] mMultiLines = EMPTY_INT_ARRAY;

    RegexpHeaderInfo() {
    }

    void setMultiLines(int[] aList) {
        if (aList == null || aList.length == 0) {
            this.mMultiLines = EMPTY_INT_ARRAY;
            return;
        }
        this.mMultiLines = new int[aList.length];
        System.arraycopy(aList, 0, this.mMultiLines, 0, aList.length);
        Arrays.sort(this.mMultiLines);
    }

    int[] getMultLines() {
        return this.mMultiLines;
    }

    Pattern[] geHeaderRegexps() {
        return this.mHeaderRegexps;
    }

    protected void postprocessHeaderLines() {
        String[] headerLines = this.getHeaderLines();
        if (headerLines != null) {
            this.mHeaderRegexps = new Pattern[headerLines.length];
            for (int i = 0; i < headerLines.length; ++i) {
                try {
                    this.mHeaderRegexps[i] = Utils.getPattern(headerLines[i]);
                    continue;
                }
                catch (PatternSyntaxException ex) {
                    throw new ConversionException("line " + (i + 1) + " in header specification" + " is not a regular expression");
                }
            }
        }
    }
}

