/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class MultipleStringLiteralsCheck
extends Check {
    private final HashMap mStringMap = new HashMap();
    private int mAllowedDuplicates = 1;
    private Pattern mPattern;

    public void setAllowedDuplicates(int aAllowedDuplicates) {
        this.mAllowedDuplicates = aAllowedDuplicates;
    }

    public MultipleStringLiteralsCheck() {
        this.setIgnoreStringsRegexp("^\"\"$");
    }

    public void setIgnoreStringsRegexp(String aIgnoreStringsRegexp) {
        this.mPattern = aIgnoreStringsRegexp != null && aIgnoreStringsRegexp.length() > 0 ? Utils.getPattern(aIgnoreStringsRegexp) : null;
    }

    public int[] getDefaultTokens() {
        return new int[]{139};
    }

    public void visitToken(DetailAST aAST) {
        String currentString = aAST.getText();
        if (this.mPattern == null || !this.mPattern.matcher(currentString).find()) {
            ArrayList<StringInfo> hitList = (ArrayList<StringInfo>)this.mStringMap.get(currentString);
            if (hitList == null) {
                hitList = new ArrayList<StringInfo>();
                this.mStringMap.put(currentString, hitList);
            }
            int line = aAST.getLineNo();
            int col = aAST.getColumnNo();
            hitList.add(new StringInfo(line, col));
        }
    }

    public void beginTree(DetailAST aRootAST) {
        super.beginTree(aRootAST);
        this.mStringMap.clear();
    }

    public void finishTree(DetailAST aRootAST) {
        Set keys = this.mStringMap.keySet();
        Iterator keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            ArrayList hits = (ArrayList)this.mStringMap.get(key);
            if (hits.size() <= this.mAllowedDuplicates) continue;
            StringInfo firstFinding = (StringInfo)hits.get(0);
            int line = firstFinding.getLine();
            int col = firstFinding.getCol();
            Object[] args = new Object[]{key, new Integer(hits.size())};
            this.log(line, col, "multiple.string.literal", args);
        }
    }

    private static final class StringInfo {
        private final int mLine;
        private final int mCol;

        private StringInfo(int aLine, int aCol) {
            this.mLine = aLine;
            this.mCol = aCol;
        }

        private int getLine() {
            return this.mLine;
        }

        private int getCol() {
            return this.mCol;
        }
    }
}

