/*
 * Decompiled with CFR 0.152.
 */
package ricoh.ant.samba;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import jcifs.Config;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SambaTask
extends Task {
    private ArrayList filesetList;
    private String srcFilename;
    private String destFilename;
    private int srcFileType;
    private int destFileType;
    private boolean isDestDir;
    private String srcRemotePath;
    private String srcHost;
    private String srcUsername;
    private String srcPassword;
    private String srcUrl;
    private String srcDomain;
    private int srcPort;
    private String destRemotePath;
    private String destHost;
    private String destUsername;
    private String destPassword;
    private String destUrl;
    private String destDomain;
    private int destPort;
    public static final int LOCAL_SRC_FILE = 0;
    public static final int REMOTE_SRC_FILE = 1;
    public static final int LOCAL_DEST_FILE = 2;
    public static final int REMOTE_DEST_FILE = 3;
    public static final int UPLOAD_OPERATION = 0;
    public static final int DOWNLOAD_OPERATION = 1;
    public static final int REMOTE_OPERATION = 2;
    private boolean sourceEntered = false;
    private boolean destEntered = false;
    private int BUFFER_SIZE = 4096;
    public static final int DEFAULT_SAMBA_PORT = 139;

    public void init() {
        Config.registerSmbURLHandler();
        this.sourceEntered = false;
        this.destEntered = false;
        this.srcUrl = null;
        this.destUrl = null;
        this.srcHost = null;
        this.destHost = null;
        this.srcUsername = "";
        this.destUsername = "";
        this.srcPassword = "";
        this.destPassword = "";
        this.srcDomain = null;
        this.destDomain = null;
        this.srcRemotePath = null;
        this.destRemotePath = null;
        this.srcPort = 139;
        this.destPort = 139;
        this.filesetList = new ArrayList();
    }

    public void setFile(String filename) throws BuildException {
        this.checkWildcards(filename);
        if (!this.sourceEntered) {
            if (filename.startsWith("smb://")) {
                this.srcFileType = 1;
                this.srcFilename = filename;
                this.srcUrl = filename;
                FileSet fs = new FileSet();
                fs.setFile(new File(this.srcFilename));
                this.filesetList.add(fs);
                this.sourceEntered = true;
                return;
            }
            this.srcFileType = 0;
            this.srcFilename = filename;
            FileSet fs = new FileSet();
            fs.setFile(new File(this.srcFilename));
            this.filesetList.add(fs);
            this.sourceEntered = true;
            return;
        }
        if (this.srcFilename != null) {
            throw new BuildException("More than one source given: " + this.srcFilename + " and " + filename + "\n" + "Use a fileset for multiple sources");
        }
        throw new BuildException("More than one source given: " + this.srcUrl + " and " + filename + "\n" + "Use a fileset for multiple sources");
    }

    public void setLocalFile(String localFilename) throws BuildException {
        this.checkWildcards(localFilename);
        if (!this.sourceEntered) {
            this.srcFilename = localFilename;
            this.srcFileType = 0;
            FileSet fs = new FileSet();
            fs.setFile(new File(this.srcFilename));
            this.sourceEntered = true;
            return;
        }
        if (this.srcFilename != null) {
            throw new BuildException("More than one source given: " + this.srcFilename + " and " + localFilename + "\n" + "Use a fileset for multiple sources");
        }
        throw new BuildException("More than one source given: " + this.srcUrl + " and " + localFilename + "\n" + "Use a fileset for multiple sources");
    }

    public void setRemoteFile(String remoteFile) throws BuildException {
        this.checkWildcards(remoteFile);
        if (!this.sourceEntered) {
            this.srcUrl = remoteFile;
            this.srcFileType = 1;
            this.sourceEntered = true;
            return;
        }
        if (this.srcFilename != null) {
            throw new BuildException("More than one source given: " + this.srcFilename + " and " + remoteFile + "\n" + "Use a fileset for multiple sources");
        }
        throw new BuildException("More than one source given: " + this.srcUrl + " and " + remoteFile + "\n" + "Use a fileset for multiple sources");
    }

    public void setToDir(String destDir) throws BuildException {
        if (!this.destEntered) {
            if (destDir.startsWith("smb://")) {
                this.destFileType = 3;
                this.destUrl = destDir;
                if (!destDir.endsWith("/")) {
                    destDir = destDir + "/";
                }
            } else {
                this.destFileType = 2;
                this.destFilename = destDir;
                if (!destDir.endsWith(File.separator)) {
                    destDir = destDir + File.separator;
                }
            }
            this.isDestDir = true;
            this.destEntered = true;
            return;
        }
        if (this.destFilename != null) {
            throw new BuildException("More than one destination given: " + destDir + " and " + this.destFilename);
        }
        throw new BuildException("More than one destination given: " + destDir + " and " + this.destUrl);
    }

    public void setLocalToDir(String destDir) throws BuildException {
        if (!this.destEntered) {
            this.destFilename = destDir;
            if (!this.destFilename.endsWith(File.pathSeparator)) {
                this.destFilename = this.destFilename + File.pathSeparator;
            }
            this.destFileType = 2;
            this.isDestDir = true;
            this.destEntered = true;
            return;
        }
        if (this.destFilename != null) {
            throw new BuildException("More than one destination given: " + destDir + " and " + this.destFilename);
        }
        throw new BuildException("More than one destination given: " + destDir + " and " + this.destUrl);
    }

    public void setLocalToFile(String destFile) throws BuildException {
        if (!this.destEntered) {
            this.destFilename = destFile;
            this.destFileType = 2;
            this.isDestDir = false;
            this.destEntered = true;
            return;
        }
        if (this.destFilename != null) {
            throw new BuildException("More than one destination given: " + destFile + " and " + this.destFilename);
        }
        throw new BuildException("More than one destination given: " + destFile + " and " + this.destUrl);
    }

    public void setRemoteToDir(String destDir) throws BuildException {
        if (!this.destEntered) {
            this.destUrl = destDir;
            this.destFileType = 3;
            if (!this.destUrl.endsWith("/")) {
                this.destUrl = this.destUrl + "/";
            }
            this.isDestDir = true;
            this.destEntered = true;
            return;
        }
        if (this.destFilename != null) {
            throw new BuildException("More than one destination given: " + destDir + " and " + this.destFilename);
        }
        throw new BuildException("More than one destination given: " + destDir + " and " + this.destUrl);
    }

    public void setRemoteToFile(String destFile) throws BuildException {
        if (!this.destEntered) {
            this.destUrl = destFile;
            this.destFileType = 3;
            this.isDestDir = false;
            this.destEntered = true;
            return;
        }
        if (this.destUrl != null) {
            throw new BuildException("More than one destination given: " + destFile + " and " + this.destFilename);
        }
        throw new BuildException("More than one destination given: " + destFile + " and " + this.destUrl);
    }

    public void setSrcPort(String port) {
        if (port == null || port.trim().equals("")) {
            this.srcPort = 139;
        } else {
            int numericPort;
            try {
                numericPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Bad format for entered source SMB port: " + port);
                nfe.printStackTrace();
                throw new BuildException(nfe.getMessage());
            }
            this.srcPort = numericPort > 0 ? numericPort : 139;
        }
    }

    public void setSrcHost(String host) {
        this.srcHost = host;
    }

    public void setSrcUsername(String user) {
        this.srcUsername = user;
    }

    public void setSrcPassword(String pass) {
        this.srcPassword = pass;
    }

    public void setSrcDomain(String domain) {
        this.srcDomain = domain;
    }

    public void setSrcURL(String url) {
        this.srcUrl = url;
    }

    public void setDestPort(String port) {
        if (port == null || port.trim().equals("")) {
            this.srcPort = 139;
        } else {
            int numericPort;
            try {
                numericPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Bad format for entered source SMB port: " + port);
                nfe.printStackTrace();
                throw new BuildException(nfe.getMessage());
            }
            this.srcPort = numericPort > 0 ? numericPort : 139;
        }
    }

    public void setDestHost(String host) {
        this.destHost = host;
    }

    public void setDestUsername(String user) {
        this.destUsername = user;
    }

    public void setDestPassword(String pass) {
        this.destPassword = pass;
    }

    public void setDestDomain(String domain) {
        this.destDomain = domain;
    }

    public void setDestURL(String url) {
        this.destUrl = url;
    }

    public void addFileset(FileSet set) throws BuildException {
        if (this.sourceEntered) {
            throw new BuildException("Single source file already provided for copying.\nUse either a fileset or single source file attribute, not both.");
        }
        this.filesetList.add(set);
        this.srcFileType = 0;
    }

    public void execute() throws BuildException {
        if (this.filesetList != null && this.filesetList.size() > 0) {
            this.sourceEntered = true;
        }
        if (this.sourceEntered && this.destEntered) {
            if (this.destFileType == 2 && this.srcFileType == 0) {
                throw new BuildException("Copying within the local file system is deprecated for this task.\nUse the copy or copydir tasks instead.");
            }
            if (this.srcFileType == 0 && this.destFileType == 3) {
                this.transfer(0);
            }
            if (this.srcFileType == 1 && this.destFileType == 2) {
                this.transfer(1);
            }
            if (this.srcFileType == 1 && this.destFileType == 3) {
                this.transfer(2);
            }
        } else {
            throw new BuildException("Required targets for source and destination unspecified.");
        }
    }

    private void transfer(int operation) throws BuildException {
        boolean usingFileSets;
        String resolvedUrl;
        Object in;
        FileOutputStream out;
        block26: {
            out = null;
            in = null;
            resolvedUrl = "none";
            usingFileSets = false;
            try {
                SmbFile srcSmbFile;
                SmbFile destSmbFile;
                if (operation == 0) {
                    usingFileSets = true;
                    resolvedUrl = this.resolveURL(3);
                    if (this.srcFilename != null) {
                        File sourceFile = new File(this.srcFilename);
                        if (!sourceFile.exists()) {
                            throw new FileNotFoundException(sourceFile.getAbsolutePath() + " was not found or does not exist.");
                        }
                        in = new FileInputStream(sourceFile);
                        if (this.isDestDir) {
                            resolvedUrl = resolvedUrl + sourceFile.getName();
                        }
                        destSmbFile = new SmbFile(resolvedUrl);
                        out = new SmbFileOutputStream(destSmbFile);
                    } else if (!this.isDestDir) {
                        throw new BuildException("Use toDir or toRemoteDir when copying filesets.");
                    }
                    break block26;
                }
                if (operation == 1) {
                    resolvedUrl = this.resolveURL(1);
                    srcSmbFile = new SmbFile(resolvedUrl);
                    in = new SmbFileInputStream(srcSmbFile);
                    if (this.isDestDir) {
                        this.destFilename = this.destFilename + srcSmbFile.getName();
                    }
                    File destFile = new File(this.destFilename);
                    out = new FileOutputStream(destFile);
                    break block26;
                }
                if (operation == 2) {
                    resolvedUrl = this.resolveURL(1);
                    srcSmbFile = new SmbFile(resolvedUrl);
                    resolvedUrl = this.resolveURL(3);
                    if (this.isDestDir) {
                        resolvedUrl = resolvedUrl + srcSmbFile.getName();
                    }
                    destSmbFile = new SmbFile(resolvedUrl);
                    in = new SmbFileInputStream(srcSmbFile);
                    out = new SmbFileOutputStream(destSmbFile);
                    break block26;
                }
                throw new BuildException("Operation unspecified");
            }
            catch (MalformedURLException mue) {
                this.log("Bad URL, check syntax and try again: " + resolvedUrl + "\n" + mue.getMessage());
                mue.printStackTrace();
                throw new BuildException();
            }
            catch (UnknownHostException uhe) {
                this.log("Unknown host or host unreachable\n" + uhe.getMessage());
                uhe.printStackTrace();
                throw new BuildException();
            }
            catch (SmbException smbe) {
                this.log("Error in connecting SMB\n" + smbe.getMessage());
                smbe.printStackTrace();
                throw new BuildException();
            }
            catch (FileNotFoundException fnfe) {
                this.log("File not found\n" + fnfe.getMessage());
                fnfe.printStackTrace();
                throw new BuildException();
            }
        }
        Iterator fileSetIterator = this.filesetList.iterator();
        byte[] buffer = new byte[this.BUFFER_SIZE];
        int byteTransmitCount = 0;
        if (usingFileSets) {
            while (fileSetIterator.hasNext()) {
                FileSet currentSet = (FileSet)fileSetIterator.next();
                DirectoryScanner ds = currentSet.getDirectoryScanner(this.getProject());
                String[] currentSetFilenames = ds.getIncludedFiles();
                for (int i = 0; i < currentSetFilenames.length; ++i) {
                    System.out.println("Transferring: " + currentSet.getDir(this.getProject()).toString() + File.separator + currentSetFilenames[i]);
                    try {
                        int sizeEndFlag;
                        in = new FileInputStream(currentSet.getDir(this.getProject()).toString() + File.separator + currentSetFilenames[i]);
                        resolvedUrl = this.resolveURL(3);
                        if (this.isDestDir) {
                            resolvedUrl = resolvedUrl + "/" + currentSetFilenames[i];
                        }
                        System.out.println("To Destination: " + resolvedUrl);
                        out = new SmbFileOutputStream(new SmbFile(resolvedUrl));
                        while ((sizeEndFlag = ((InputStream)in).read(buffer)) > 0) {
                            ((OutputStream)out).write(buffer, 0, sizeEndFlag);
                            byteTransmitCount = sizeEndFlag;
                        }
                        ((OutputStream)out).close();
                        continue;
                    }
                    catch (IOException ioe) {
                        this.log("I/O error; bytes transmitted of " + currentSetFilenames[i] + ": " + byteTransmitCount);
                        ioe.printStackTrace();
                        throw new BuildException(ioe.getMessage());
                    }
                }
            }
        } else {
            try {
                int sizeEndFlag;
                while ((sizeEndFlag = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer);
                    byteTransmitCount = sizeEndFlag;
                }
            }
            catch (IOException ioe) {
                this.log("I/O error; bytes transmitted = " + byteTransmitCount);
                this.log(ioe.getMessage());
                ioe.printStackTrace();
                throw new BuildException();
            }
        }
    }

    private String resolveURL(int remoteSourceOrDest) throws BuildException {
        if (remoteSourceOrDest == 1) {
            if (this.srcUrl != null) {
                return this.srcUrl;
            }
            if (this.srcUsername != null && this.srcPassword != null && this.srcDomain != null && this.srcHost != null) {
                return "smb://" + this.srcDomain + ";" + this.srcUsername + ":" + this.srcPassword + "@" + this.srcHost + ":" + this.srcPort + "/" + this.srcRemotePath;
            }
            if (this.srcUsername != null && this.srcPassword != null && this.srcHost != null) {
                return "smb://" + this.srcUsername + ":" + this.srcPassword + "@" + this.srcHost + ":" + this.srcPort + "/" + this.srcRemotePath;
            }
            throw new BuildException("Insufficient connection information supplied for source.");
        }
        if (remoteSourceOrDest == 3) {
            if (this.destUrl != null) {
                return this.destUrl;
            }
            if (this.destUsername != null && this.destPassword != null && this.destDomain != null && this.destHost != null) {
                return "smb://" + this.destDomain + ";" + this.destUsername + ":" + this.destPassword + "@" + this.destHost + ":" + this.destPort + "/" + this.destRemotePath;
            }
            if (this.destUsername != null && this.destPassword != null && this.destHost != null) {
                return "smb://" + this.destUsername + ":" + this.destPassword + "@" + this.destHost + ":" + this.destPort + "/" + this.destRemotePath;
            }
            throw new BuildException("Insufficient connection information supplied for destination.");
        }
        throw new BuildException("Bad argument for resolveURL(int)");
    }

    private void checkWildcards(String filename) throws BuildException {
        if (filename.contains("*") || filename.contains("?")) {
            throw new BuildException("Wildcards not supported. To copy multiple local files\nat once, use FileSets. If you wish to copy multiple\nfiles on SMB shares, consider mounting the shares\non the local filesystem.");
        }
    }
}

