/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.About;
import com.sap.mw.jco.JCO;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TraceWriter
implements JCO.TraceListener {
    private static final String CRLF = System.getProperty("line.separator");
    private static TraceWriter self = null;
    private static TraceWriter defaultTraceWriter = null;
    private static String baseTraceFileName = null;
    private static int files_count = 0;
    private static final int MAX_TRACE_FILE_LENGTH = 0x1400000;
    private File traceFile = null;
    private Writer traceWriter = null;
    private DateFormat fTime = new SimpleDateFormat("HH':'mm':'ss':'SSS");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String LF = System.getProperty("line.separator");
    private static Object mutex = new Object();

    private TraceWriter() {
    }

    private void setPath(String path) {
        if (this.traceWriter != null && path != null) {
            Writer writer = this.traceWriter;
            synchronized (writer) {
                this.traceWriter = this.createTraceWriter(path);
            }
            this.writeInfo();
        } else if (this.traceWriter == null) {
            this.traceWriter = this.createTraceWriter(path);
            this.writeInfo();
            JCO.addTraceListener(this);
        }
    }

    private Writer createNewFile(File file) {
        OutputStreamWriter writer = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
                new DataOutputStream(fos).write(new byte[]{-17, -69, -65}, 0, 3);
                fos.flush();
            }
            catch (UnsupportedEncodingException e) {
                writer = new OutputStreamWriter(new FileOutputStream(file));
            }
            return writer;
        }
        catch (IOException ex) {
            throw new RuntimeException("JCO-TraceWriter: cannot open trace file [" + file.getAbsolutePath() + "]");
        }
    }

    private Writer createTraceWriter(String path) {
        Writer traceWriter = null;
        this.traceFile = null;
        if (path == null) {
            path = "stdout";
        }
        if (path.equals("stdout")) {
            traceWriter = new OutputStreamWriter(System.out);
        } else if (path.equals("stderr")) {
            traceWriter = new OutputStreamWriter(System.err);
        } else {
            if (!new File(path).isDirectory()) {
                path = ".";
            }
            SimpleDateFormat fName = new SimpleDateFormat("'JCO'yyMMdd'_'HHmmssSSS");
            StringBuffer traceFileName = new StringBuffer(path);
            traceFileName.append(File.separator);
            traceFileName.append(fName.format(new Date()));
            baseTraceFileName = traceFileName.toString();
            traceFileName.append(".trc");
            this.traceFile = new File(traceFileName.toString());
            traceWriter = this.createNewFile(this.traceFile);
        }
        return traceWriter;
    }

    public static TraceWriter getDefaultTraceWriter() {
        Object object = mutex;
        synchronized (object) {
            if (defaultTraceWriter == null) {
                defaultTraceWriter = new TraceWriter();
                TraceWriter.defaultTraceWriter.traceWriter = defaultTraceWriter.createTraceWriter("stdout");
                defaultTraceWriter.writeInfo();
            }
        }
        return defaultTraceWriter;
    }

    public static String dumpContent(char[] chars) {
        return TraceWriter.dumpContent(chars, true, chars.length);
    }

    public static String dumpContent(char[] chars, boolean withHex, int lengthToDump) {
        if (chars == null) {
            chars = new char[]{};
        }
        if (lengthToDump < 0 || lengthToDump > chars.length) {
            lengthToDump = chars.length;
        }
        StringBuffer buf = new StringBuffer();
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        int i = 0;
        while (i < lengthToDump) {
            int k;
            buf.append("|");
            int k2 = 0;
            while (k2 < 8) {
                offsets[k2] = i / (int)Math.pow(10.0, k2) % 10;
                ++k2;
            }
            int k3 = 7;
            while (k3 >= 0) {
                buf.append(offsets[k3]);
                --k3;
            }
            buf.append("|");
            if (withHex) {
                k = 0;
                while (k < 20) {
                    if (i + k < chars.length) {
                        hexs[k * 4 + 0] = HEX[chars[i + k] >> 12 & 0xF];
                        hexs[k * 4 + 1] = HEX[chars[i + k] >> 8 & 0xF];
                        hexs[k * 4 + 2] = HEX[chars[i + k] >> 4 & 0xF];
                        hexs[k * 4 + 3] = HEX[chars[i + k] & 0xF];
                    } else {
                        hexs[k * 4 + 3] = 32;
                        hexs[k * 4 + 2] = 32;
                        hexs[k * 4 + 1] = 32;
                        hexs[k * 4] = 32;
                    }
                    ++k;
                }
                int k4 = 0;
                while (k4 < hexs.length) {
                    if (k4 != 0 && 0 == k4 % 20) {
                        buf.append(' ');
                    }
                    buf.append(hexs[k4]);
                    ++k4;
                }
                buf.append('|');
            }
            k = 0;
            while (k < 20) {
                char curChar = i + k < chars.length ? chars[i + k] : (char)' ';
                buf.append(!Character.isISOControl(curChar) && Character.isDefined(curChar) ? curChar : (char)'.');
                ++k;
            }
            buf.append('|');
            buf.append(LF);
            i += 20;
        }
        return buf.toString();
    }

    public static String dumpContent(byte[] bytes) {
        return TraceWriter.dumpContent(bytes, bytes.length);
    }

    public static String dumpContent(byte[] bytes, int lengthToDump) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (lengthToDump < 0 || lengthToDump > bytes.length) {
            lengthToDump = bytes.length;
        }
        StringBuffer buf = new StringBuffer();
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        int i = 0;
        while (i < lengthToDump) {
            buf.append("|");
            int k = 0;
            while (k < 8) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
                ++k;
            }
            int k2 = 7;
            while (k2 >= 0) {
                buf.append(offsets[k2]);
                --k2;
            }
            buf.append("|");
            int k3 = 0;
            while (k3 < 40) {
                if (i + k3 < bytes.length) {
                    hexs[k3 * 2 + 0] = HEX[bytes[i + k3] >> 4 & 0xF];
                    hexs[k3 * 2 + 1] = HEX[bytes[i + k3] & 0xF];
                } else {
                    hexs[k3 * 2 + 1] = 32;
                    hexs[k3 * 2] = 32;
                }
                ++k3;
            }
            int k4 = 0;
            while (k4 < hexs.length) {
                if (k4 != 0 && 0 == k4 % 20) {
                    buf.append(' ');
                }
                buf.append(hexs[k4]);
                ++k4;
            }
            buf.append('|');
            buf.append(LF);
            i += 40;
        }
        return buf.toString();
    }

    public static void start(String path) {
        Object object = mutex;
        synchronized (object) {
            if (self == null) {
                self = new TraceWriter();
            }
            self.setPath(path);
        }
    }

    public static void stop() {
        Object object = mutex;
        synchronized (object) {
            if (self == null) {
                return;
            }
            JCO.removeTraceListener(self);
            if (TraceWriter.self.traceWriter != null) {
                try {
                    TraceWriter.self.traceWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            self = null;
        }
    }

    public void trace(int message_level, String message) {
        try {
            Writer writer = this.traceWriter;
            synchronized (writer) {
                if (this.traceFile != null && this.traceFile.length() > 0x1400000L) {
                    this.traceWriter.close();
                    String traceFileName = baseTraceFileName + '.' + ++files_count + ".trc";
                    this.traceFile = new File(traceFileName.toString());
                    this.traceWriter = this.createNewFile(this.traceFile);
                }
                this.traceWriter.write(Thread.currentThread().getName());
                this.traceWriter.write(" [");
                this.traceWriter.write(this.fTime.format(new Date()));
                this.traceWriter.write("]");
                this.traceWriter.write(": ");
                this.traceWriter.write(message);
                this.traceWriter.write(CRLF);
                this.traceWriter.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("TraceWriter.trace(): " + ex.toString());
        }
    }

    private void writeInfo() {
        if (this.traceWriter == null) {
            return;
        }
        new About().printTo(new PrintWriter(this.traceWriter));
        this.trace(0, "********************  " + new Date() + "   ***************************");
    }

    protected void finalize() throws Throwable {
        JCO.removeTraceListener(this);
        if (this.traceWriter != null) {
            try {
                this.traceWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public static void main(String[] arg) {
    }
}

