/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.util.ObjectList;
import java.io.Serializable;

public class LimitedList
implements Cloneable,
Serializable {
    protected Object[] m_list = null;
    protected int m_first = 0;
    protected int m_end = 0;

    public LimitedList() {
        this(0);
    }

    public LimitedList(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit < 0 [" + limit + "<0]");
        }
        this.m_list = new Object[limit];
    }

    public LimitedList(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("objectArray == null");
        }
        int i = 0;
        while (i < objectArray.length) {
            if (objectArray[i] == null) {
                throw new IllegalArgumentException("objectArray[" + i + "] == null");
            }
            ++i;
        }
        this.m_list = (Object[])objectArray.clone();
    }

    public final void clear() {
        int i = 0;
        while (i < this.m_list.length) {
            this.m_list[i] = null;
            ++i;
        }
        this.m_end = 0;
        this.m_first = 0;
    }

    public final void setLimit(int limit) {
        int size = this.size();
        if (limit < size) {
            throw new IllegalArgumentException("limit is less than current size");
        }
        Object[] oldList = this.m_list;
        this.m_list = new Object[limit];
        if (size == 0) {
            return;
        }
        if (this.m_end > this.m_first) {
            System.arraycopy(oldList, this.m_first, this.m_list, 0, this.m_end - this.m_first);
        } else if (this.m_end <= this.m_first) {
            System.arraycopy(oldList, this.m_first, this.m_list, 0, oldList.length - this.m_first);
            System.arraycopy(oldList, 0, this.m_list, oldList.length - this.m_first, this.m_end);
        }
        this.m_first = 0;
        this.m_end = size;
    }

    public final int getLimit() {
        return this.m_list.length;
    }

    public final int size() {
        int size;
        if (this.m_end >= this.m_first) {
            size = this.m_end - this.m_first;
            if (size == 0 && this.m_list[this.m_first] != null) {
                size = this.m_list.length;
            }
        } else {
            size = this.m_list.length - this.m_first + this.m_end;
        }
        return size;
    }

    public final Object clone() {
        try {
            ObjectList cloned = (ObjectList)super.clone();
            cloned.m_list = (Object[])this.m_list.clone();
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0, true) > -1;
    }

    public final Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.size() + "]");
        }
        return this.m_list[(index + this.m_first) % this.m_list.length];
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0, true);
    }

    public final int indexOf(Object object, int startIndex) {
        return this.indexOf(object, startIndex, true);
    }

    public final int indexOf(Object object, int startIndex, boolean searchForward) {
        block8: {
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("startIndex < 0 [" + startIndex + "<0]");
            }
            if (startIndex > 0 && startIndex >= this.size()) {
                throw new IndexOutOfBoundsException("startIndex >= size() [" + startIndex + ">=" + this.size() + "]");
            }
            if (object == null) break block8;
            if (searchForward) {
                int size = this.size();
                int i = startIndex;
                while (i < size) {
                    if (this.m_list[(i + this.m_first) % this.m_list.length].equals(object)) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = this.size();
                while (i >= 0) {
                    if (this.m_list[(i + this.m_first) % this.m_list.length].equals(object)) {
                        return i;
                    }
                    --i;
                }
            }
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.m_first == this.m_end && this.m_list[this.m_first] == null;
    }

    public final int lastIndexOf(Object object) {
        if (this.isEmpty()) {
            return -1;
        }
        return this.indexOf(object, this.size() - 1, false);
    }

    public final Object pop() {
        if (this.isEmpty()) {
            return null;
        }
        if (--this.m_end < 0) {
            this.m_end = this.m_list.length - 1;
        }
        Object to_pop = this.m_list[this.m_end];
        this.m_list[this.m_end] = null;
        return to_pop;
    }

    public final Object push(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        Object removed = this.m_list[this.m_end];
        this.m_list[this.m_end] = object;
        ++this.m_end;
        if (this.m_end == this.m_list.length) {
            this.m_end = 0;
        }
        if (removed != null) {
            ++this.m_first;
            if (this.m_first == this.m_list.length) {
                this.m_first = 0;
            }
            return removed;
        }
        return null;
    }

    public final Object remove(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.size() + "]");
        }
        index = (this.m_first + index) % this.m_list.length;
        Object removed = this.m_list[index];
        this.m_list[index] = this.m_list[this.m_first];
        this.m_list[this.m_first] = null;
        ++this.m_first;
        if (this.m_first == this.m_list.length) {
            this.m_first = 0;
        }
        return removed;
    }

    public final boolean remove(Object object) {
        int index = this.indexOf(object, 0, true);
        if (index >= 0) {
            this.remove(index);
        }
        return index >= 0;
    }

    public final Object set(int index, Object object) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.size() + "]");
        }
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        index = (this.m_first + index) % this.m_list.length;
        Object replaced = this.m_list[index];
        this.m_list[index] = object;
        return replaced;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.size()];
        System.arraycopy(this.m_list, 0, array, 0, this.size());
        return array;
    }

    public static void main(String[] a) {
        LimitedList l = new LimitedList(10);
        Object obj = null;
        while (obj == null) {
            obj = l.push(new Integer(10));
        }
        l.size();
        l.pop();
    }
}

