/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.utils.XmlUtil;
import org.w3c.dom.Element;

public class RuntimeAttribute {
    public static final String TAG_ATTR = "runtimeAttr";
    static final String LOG_CATEGORY = RuntimeAttribute.class.getName();
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private String attributeName;
    private Object attributeValue;
    private int jdbcType;

    public RuntimeAttribute() {
    }

    public RuntimeAttribute(String name, String value, int type) {
        if (StringUtil.isNullString(name)) {
            throw new IllegalArgumentException("Must supply non-empty String value for name.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Must supply non-null Object ref for value.");
        }
        this.jdbcType = type;
        this.attributeName = name;
        this.attributeValue = value;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        boolean response = false;
        if (o instanceof RuntimeAttribute) {
            RuntimeAttribute attr = (RuntimeAttribute)o;
            response = this.attributeName != null ? this.attributeName.equals(attr.attributeName) : attr.attributeName == null;
            response &= this.jdbcType == attr.jdbcType;
            response &= this.attributeValue != null ? this.attributeValue.equals(attr.attributeValue) : attr.attributeValue != null;
        }
        return response;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Object getAttributeObject() {
        return this.attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue.toString();
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode += this.attributeName != null ? this.attributeName.hashCode() : 0;
        hashCode += this.jdbcType;
        return hashCode += this.attributeValue != null ? this.attributeValue.hashCode() : 0;
    }

    public void parseXMLString(Element xmlElement) throws BaseException {
        this.attributeName = xmlElement.getAttribute(ATTR_NAME);
        this.attributeValue = xmlElement.getAttribute(ATTR_VALUE);
        String typeStr = xmlElement.getAttribute(ATTR_TYPE);
        try {
            this.jdbcType = Integer.parseInt(typeStr);
        }
        catch (NumberFormatException e) {
            throw new BaseException("Invalid JDBC type in RuntimeAttribute element.");
        }
    }

    public void setAttributeName(String aName) {
        this.attributeName = aName;
    }

    public void setAttributeValue(Object aValue) {
        this.attributeValue = aValue;
    }

    public void setAttributeValue(String aValue) {
        this.attributeValue = aValue;
    }

    public void setJdbcType(int aType) {
        this.jdbcType = aType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RuntimeAttribute: {").append(this.attributeName).append("=");
        if (this.attributeValue == null) {
            buf.append("<null>");
        } else {
            switch (this.jdbcType) {
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    buf.append("'").append(this.attributeValue).append("'");
                    break;
                }
                default: {
                    buf.append(this.attributeValue);
                }
            }
        }
        buf.append("}");
        return buf.toString();
    }

    public String toXMLString() {
        return this.toXMLString("");
    }

    public String toXMLString(String prefix) {
        StringBuffer xml = new StringBuffer();
        if (prefix == null) {
            prefix = "";
        }
        if (this.attributeValue != null) {
            xml.append(prefix);
            xml.append("<runtimeAttr ");
            xml.append("name=\"" + this.attributeName).append("\" ");
            xml.append("type=\"" + this.jdbcType).append("\" ");
            xml.append("value=\"");
            xml.append(this.attributeValue != null ? XmlUtil.escapeXML(this.attributeValue.toString()) : "");
            xml.append("\" />\n");
        }
        return xml.toString();
    }
}

