/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.jdbc;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.Attribute;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SQLPart {
    public static final char STATEMENT_SEPARATOR = '\uffff';
    public static final String STMT_CHECKTABLEEXISTS = "checkTableExists";
    public static final String STMT_CREATE = "createStatement";
    public static final String STMT_CREATEBEFOREPROCESS = "createBeforeProcess";
    public static final String STMT_CREATEDBLINK = "createDbLinkStatement";
    public static final String STMT_CREATEEXTERNAL = "createExternalStatement";
    public static final String STMT_CREATEFLATFILE = "createFlatfileStatement";
    public static final String STMT_CREATELOGDETAILSTABLE = "createDetailsTableStatement";
    public static final String STMT_CREATELOGSUMMARYTABLE = "createSummaryTableStatement";
    public static final String STMT_CREATEREMOTELOGDETAILSTABLE = "createRemoteDetailsTableStatement";
    public static final String STMT_DEFRAG = "defragStatement";
    public static final String STMT_DELETE = "deleteStatement";
    public static final String STMT_DELETEBEFOREPROCESS = "deleteBeforeProcessStatement";
    public static final String STMT_DELETEINVALIDROWFROMSUMMARY = "deleteInvalidRowFromSummaryTable";
    public static final String STMT_DROP = "dropStatement";
    public static final String STMT_DROPDBLINK = "dropDbLinkStatement";
    public static final String STMT_INITIALIZESTATEMENTS = "initializeStatements";
    public static final String STMT_INSERT = "insertStatement";
    public static final String STMT_INSERTEXECUTIONRECORD = "insertExecutionRecordStatement";
    public static final String STMT_INSERTSELECT = "insertSelectStatement";
    public static final String STMT_MERGE = "mergeStatement";
    public static final String STMT_REMOUNTREMOTETABLE = "remountRemoteTableStatement";
    public static final String STMT_ROWCOUNT = "rowCountStatement";
    public static final String STMT_SELECT = "selectStatement";
    public static final String STMT_SELECTEXECUTIONIDFROMSUMMARY = "selectExecutionIdFromSummaryTable";
    public static final String STMT_SELECTREJECTEDROWCTFROMDETAILS = "selectRejectedRowCountFromDetailsTable";
    public static final String STMT_STATICINSERT = "staticInsertStatement";
    public static final String STMT_TRUNCATE = "truncateStatement";
    public static final String STMT_TRUNCATEBEFOREPROCESS = "truncateBeforeProcessStatement";
    public static final String STMT_UPDATE = "updateStatement";
    public static final String STMT_UPDATEEXECUTIONRECORD = "updateExecutionRecordStatement";
    public static final String STMT_CORRELATED_SELECT = "correlatedSelect";
    public static final String STMT_CORRELATED_UPDATE = "correlatedUpdate";
    public static final String TAG_SQLPART = "sqlPart";
    private static final String ATTR_DEFAULT_NAME = "defaultFileName";
    private static final String ATTR_POOLNAME = "connPoolName";
    private static final String ATTR_TABLE_NAME = "tableName";
    private static final String ATTR_TYPE = "stmtType";
    private static final String XML_STATEMENT_SEPARATOR = "{@#END#@}";
    public static final String ATTR_JDBC_TYPE_LIST = "jdbcTypeList";
    public static final String ATTR_DESTS_SRC = "DestinationsSource";
    private Map attributes = new HashMap();
    private String connPoolName;
    private String defaultFileName;
    private String sql;
    private Map sqlStmtMap = new HashMap();
    private String tableName;
    private String type;

    public SQLPart(Element sqlElement) throws BaseException {
        this.parseXML(sqlElement);
    }

    public SQLPart(String theTableName) {
        this.setTableName(theTableName);
    }

    public SQLPart(String statement, String sqlType, String connectionPool) {
        this.setSQL(statement);
        this.setType(sqlType);
        this.setConnectionPoolName(connectionPool);
    }

    public void addSQLStatement(String stmtType, String theSQL) {
        this.sqlStmtMap.put(stmtType, theSQL);
    }

    public Collection getAllSQLStatements() {
        return this.sqlStmtMap.values();
    }

    public Attribute getAttribute(String attrName) {
        return (Attribute)this.attributes.get(attrName);
    }

    public Collection getAttributeNames() {
        return this.attributes.keySet();
    }

    public Object getAttributeObject(String attrName) {
        Attribute attr = this.getAttribute(attrName);
        return attr != null ? attr.getAttributeValue() : null;
    }

    public String getConnectionPoolName() {
        return this.connPoolName;
    }

    public String getDefaultValue() {
        return this.defaultFileName;
    }

    public Iterator getIterator() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.sql != null && !"".equals(this.sql)) {
            StringTokenizer st = new StringTokenizer(this.sql, Character.toString('\uffff'));
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list.iterator();
    }

    public Map getTypeToStatementMap() {
        return this.sqlStmtMap;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getSQL(String stmtType) {
        return (String)this.sqlStmtMap.get(stmtType);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType() {
        return this.type;
    }

    public void parseXML(Element element) throws BaseException {
        if (element == null) {
            throw new BaseException("Must supply non-null Element ref for parameter 'element'.");
        }
        this.connPoolName = element.getAttribute(ATTR_POOLNAME);
        if (StringUtil.isNullString(this.connPoolName)) {
            throw new BaseException("XML element has an empty or missing value for attribute 'connPoolName'.");
        }
        this.type = element.getAttribute(ATTR_TYPE);
        if (StringUtil.isNullString(this.type)) {
            throw new BaseException("XML element has an empty or missing value for attribute 'stmtType'.");
        }
        this.tableName = element.getAttribute(ATTR_TABLE_NAME);
        this.defaultFileName = element.getAttribute(ATTR_DEFAULT_NAME);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node aNode = children.item(i);
            if (aNode.getNodeType() != 1) continue;
            Element elem = (Element)aNode;
            if (elem.getNodeName().equals("attr")) {
                Attribute attr = new Attribute();
                attr.parseXMLString(elem);
                this.attributes.put(attr.getAttributeName(), attr);
                continue;
            }
            if (!elem.getNodeName().equals("sql")) continue;
            try {
                NodeList sqlChildren = elem.getChildNodes();
                Node sqlNode = sqlChildren.item(0);
                this.sql = ((Text)sqlNode).getData();
                if (this.sql == null || this.sql.trim().length() == 0) {
                    throw new BaseException("XML element has no SQL statement!");
                }
                this.sql = StringUtil.replaceInString(this.sql, XML_STATEMENT_SEPARATOR, Character.toString('\uffff')).trim();
                continue;
            }
            catch (DOMException e) {
                throw new BaseException("Caught DOMException while parsing SQLPart.", e);
            }
        }
    }

    public void setAttribute(String attrName, Object val) {
        Attribute attr = this.getAttribute(attrName);
        if (attr != null) {
            attr.setAttributeValue(val);
        } else {
            attr = new Attribute(attrName, val);
            this.attributes.put(attrName, attr);
        }
    }

    public void setConnectionPoolName(String newPoolName) {
        this.connPoolName = newPoolName;
    }

    public void setDefaultValue(String defValue) {
        this.defaultFileName = defValue;
    }

    public void setSQL(String newSQL) {
        this.sql = newSQL;
    }

    public void setTableName(String theTableName) {
        this.tableName = theTableName;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(60);
        if (this.sql != null && !"".equals(this.sql)) {
            StringTokenizer st = new StringTokenizer(this.sql, Character.toString('\uffff'));
            while (st.hasMoreTokens()) {
                buf.append(st.nextToken() + "\n\n");
            }
        }
        return buf.toString();
    }

    public String toXMLString() {
        return this.toXMLString("");
    }

    public String toXMLString(String prefix) {
        StringBuffer buf = new StringBuffer(200);
        if (prefix == null) {
            prefix = "";
        }
        buf.append(prefix).append("<sqlPart ");
        buf.append("connPoolName=\"").append(this.connPoolName).append("\" ");
        if (!StringUtil.isNullString(this.tableName) && this.tableName.startsWith("\"")) {
            this.tableName = XmlUtil.escapeXML(this.tableName);
        }
        buf.append("tableName=\"").append(this.tableName).append("\" ");
        buf.append("defaultFileName=\"").append(this.defaultFileName).append("\" ");
        buf.append("stmtType=\"").append(this.type).append("\">\n");
        if (this.sql != null && this.sql.trim().length() != 0) {
            buf.append(prefix + "\t<sql>").append(XmlUtil.escapeXML(StringUtil.replaceInString(this.sql.trim(), Character.toString('\uffff'), XML_STATEMENT_SEPARATOR)).trim()).append("</sql>\n");
        }
        buf.append(this.toXMLAttributeTags(prefix));
        buf.append(prefix).append("</sqlPart>\n");
        return buf.toString();
    }

    protected String toXMLAttributeTags(String prefix) {
        StringBuffer buf = new StringBuffer(100);
        for (Attribute attr : this.attributes.values()) {
            if (attr.getAttributeValue() == null) continue;
            buf.append(attr.toXMLString(prefix + "\t"));
        }
        return buf.toString();
    }
}

