/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    private static HashMap managers = new HashMap();
    private ResourceBundle bundle;

    public static synchronized MessageManager getManager(Class theClass) {
        return MessageManager.getManager(theClass.getPackage().getName());
    }

    public static synchronized MessageManager getManager(String packageName) {
        if (managers != null) {
            MessageManager mgr = (MessageManager)managers.get(packageName);
            if (mgr == null) {
                mgr = new MessageManager(packageName);
                managers.put(packageName, mgr);
            }
            return mgr;
        }
        managers = new HashMap();
        MessageManager mgr = new MessageManager(packageName);
        managers.put(packageName, mgr);
        return mgr;
    }

    private MessageManager(String packageName) {
        String bundleName = packageName + ".";
        bundleName = bundleName + "LocalStrings";
        this.bundle = ResourceBundle.getBundle(bundleName);
    }

    public synchronized String getString(String key) {
        String str;
        if (key == null) {
            String msg = "key is null";
            throw new NullPointerException(msg);
        }
        if (this.bundle == null) {
            String message = " Could load Resources ";
            throw new NullPointerException(message);
        }
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = "Cannot find message associated with key '" + key + "'";
        }
        return str;
    }

    public synchronized String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }

    public String getString(String key, Object[] args) {
        String iString;
        String value = this.getString(key);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            iString = MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[" + i + "]=" + args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }
}

