/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.jdbc.SQLUtils;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PipelineTask
extends SimpleTask {
    protected static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    private static final String LOG_CATEGORY = PipelineTask.class.getName();
    private Connection conn;

    public void cleanUp() {
        super.cleanUp();
    }

    public void handleException(ETLException ex) {
        Logger.print(10000, LOG_CATEGORY, "Handling Exception for Pipeline....");
        Logger.printThrowable(10000, LOG_CATEGORY, this.DN, ex.getMessage(), ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(ETLTaskNode node) throws ETLException {
        if (node == null) {
            throw new ETLException(this.getTaskName() + " task node is null....");
        }
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        String msg = this.getMessageStarted();
        Logger.print(10000, LOG_CATEGORY, this.DN + msg);
        node.fireETLEngineLogEvent(msg);
        SQLPart transformSQLPart = this.getTransformSQLPart(node);
        String insertSelect = transformSQLPart.getSQL();
        List connList = node.getParent().getConnectionDefList();
        this.conn = null;
        PreparedStatement stmt = null;
        String conName = transformSQLPart.getConnectionPoolName();
        ETLEngineContext context = node.getParent().getContext();
        ETLEngineContext.CollabStatistics stats = context.getStatistics();
        try {
            this.conn = this.getConnection(conName, connList);
            StringBuffer tmpMessage = new StringBuffer(100);
            tmpMessage.append(this.getTaskName());
            tmpMessage.append("<");
            tmpMessage.append(node.getId());
            tmpMessage.append("> - got connection: ");
            tmpMessage.append(this.conn);
            Logger.print(10000, LOG_CATEGORY, tmpMessage.toString());
            Timestamp startTime = super.createExecutionEntryInSummaryTable(node);
            stats.setTableStartTime(node.getTableName(), startTime);
            int executionId = super.getExecutionEntryIdFromSummaryTable(node, startTime);
            stats.setTableExecutionId(node.getTableName(), executionId);
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(3, node.getTableName(), "" + executionId);
            node.fireETLEngineExecutionEvent(evnt);
            if (!this.createBeforeProcess(node, this.conn)) {
                this.truncateBeforeProcess(node, this.conn);
            }
            String startMsg = MSG_MGR.getString("MSG_common_insert_attempt");
            Logger.print(10000, LOG_CATEGORY, startMsg);
            node.fireETLEngineLogEvent(startMsg);
            String showSqlMsg = MSG_MGR.getString("MSG_common_using_sql", insertSelect);
            Logger.print(10000, LOG_CATEGORY, showSqlMsg);
            node.fireETLEngineLogEvent(showSqlMsg);
            StringTokenizer st = new StringTokenizer(insertSelect, Character.toString('\uffff'));
            ArrayList paramList = new ArrayList();
            HashMap attribMap = new HashMap(node.getParent().getInputAttrMap());
            this.populateExecutionId(attribMap, paramList, executionId);
            long insertCt = 0L;
            while (st.hasMoreElements()) {
                String currStmt = st.nextToken();
                String ps = SQLUtils.createPreparedStatement(currStmt, attribMap, paramList);
                stmt = this.conn.prepareStatement(ps);
                SQLUtils.populatePreparedStatement(stmt, attribMap, paramList);
                int rows = stmt.executeUpdate();
                insertCt += rows > 0 ? (long)rows : 0L;
                if (rows == -3) {
                    String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", currStmt);
                    Logger.print(40000, LOG_CATEGORY, errMsg);
                    node.fireETLEngineLogEvent(errMsg);
                }
                stmt.close();
            }
            stats.setRowsInsertedCount(node.getTableName(), insertCt);
            Timestamp endDate = new Timestamp(System.currentTimeMillis());
            stats.setTableFinishTime(node.getTableName(), endDate);
            String successMsg = MSG_MGR.getString("MSG_common_insert_success", new Long(insertCt));
            Logger.print(20000, LOG_CATEGORY, successMsg);
            node.fireETLEngineLogEvent(successMsg);
            context.putValue(node.getTableName(), new Long(insertCt));
            context.commitLater(this.conn);
            evnt = new ETLEngineExecEvent(4, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
            node.fireETLEngineExecutionEvent(evnt);
            this.closeStatement(stmt);
        }
        catch (Exception ex) {
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(5, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
            evnt.setCause(ex);
            node.fireETLEngineExecutionEvent(evnt);
            this.handleException(node, context, ex);
        }
        finally {
            this.closeStatement(stmt);
        }
        String doneMsg = this.getMessageFinished();
        Logger.print(10000, LOG_CATEGORY, doneMsg);
        node.fireETLEngineLogEvent(doneMsg);
        return "Success";
    }

    protected String getMessageFinished() {
        return MSG_MGR.getString("MSG_pipeline_finished");
    }

    protected String getMessageStarted() {
        return MSG_MGR.getString("MSG_pipeline_started");
    }

    protected String getTaskName() {
        return "Pipeline";
    }

    protected void populateExecutionId(Map attribMap, List paramList, int value) {
    }

    private SQLPart getTransformSQLPart(ETLTaskNode node) throws ETLException {
        SQLPart transformSQLPart = node.getStatement("staticInsertStatement");
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("insertSelectStatement");
        }
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("mergeStatement");
        }
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("updateStatement");
        }
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("deleteStatement");
        }
        if (transformSQLPart == null) {
            throw new ETLException("No SQL statement to execute in this transform node.");
        }
        return transformSQLPart;
    }

    private void handleException(ETLTaskNode node, ETLEngineContext context, Throwable t) throws ETLException {
        String msg = (t = this.unwrapThrowable(t)).getMessage();
        if (StringUtil.isNullString(msg)) {
            msg = t.toString();
        }
        String failureMsg = MSG_MGR.getString("MSG_common_insert_failure", msg);
        Logger.print(10000, LOG_CATEGORY, (Object)failureMsg, t);
        node.fireETLEngineLogEvent(failureMsg);
        try {
            if (this.conn != null) {
                if (!this.conn.getAutoCommit()) {
                    Logger.print(10000, LOG_CATEGORY, "Rolling back transactions");
                    this.conn.rollback();
                }
                context.closeAndReleaseLater(this.conn);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        throw new ETLException(failureMsg, t);
    }
}

