/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.utils.AttributeMap;
import com.sun.sql.framework.utils.StringUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.CharStreamTokenizer;
import org.axiondb.io.FileUtil;

public class Loader
extends SimpleTask {
    private ETLTaskNode taskNode;
    private AxionFileSystem FS = new AxionFileSystem();
    private static final String LOG_CATEGORY = Loader.class.getName();
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    public static final String KEY_JOBQUEUESIZE = "jobQueueSize";
    public static final String KEY_PARTITIONSIZE = "partitionSize";
    private static int batchSize = 5000;
    private static String fileLocation;
    private static String _lineSep;
    private static String fieldDelimiter;
    private static String qualifier;
    private int partitions = 1;
    private int jobQueueSize = 2;
    private int rowsToSkip = 0;
    private int colCount = 0;
    private boolean _isQuoted = false;
    private char[] _fieldSepChar;
    private char[] _qualifierChar;
    protected String[] _lineSeps;
    protected char[][] _lineSepsChar;
    protected Pattern _qPattern;
    protected Pattern _qqPattern;
    private CharStreamTokenizer _streamTokenizer;
    private ExecutorService consumerThread;
    private BlockingQueue<PreparedStatement> jobQueue;
    private BlockingQueue<PreparedStatement> preparedStmtPool;
    private BatchProcessingConsumer consumer;

    public void cleanUp() {
        super.cleanUp();
    }

    public void handleException(ETLException ex) {
        super.handleException(ex);
    }

    public String process(ETLTaskNode node) throws ETLException {
        if (node == null) {
            throw new ETLException("Task node is null....");
        }
        this.taskNode = node;
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        String msg = MSG_MGR.getString("MSG_LOADER_started");
        node.fireETLEngineLogEvent(msg, 10000);
        try {
            SQLPart insertSQLPart;
            int bsInt;
            List connList = node.getParent().getConnectionDefList();
            AttributeMap attrMap = node.getAttributeMap();
            String batchSizeStr = (String)attrMap.getAttributeValue("batchSize");
            if (!StringUtil.isNullString(batchSizeStr) && (bsInt = StringUtil.getInt(batchSizeStr)) > 0) {
                batchSize = bsInt;
            }
            if ((insertSQLPart = node.getStatement("insertStatement")) == null) {
                throw new ETLException(this.DN + "Missing required insert SQLPart element");
            }
            String insertStmt = insertSQLPart.getSQL();
            if (insertStmt == null) {
                throw new ETLException(this.DN + "Missing required insert statement");
            }
            this.initializeProperties(attrMap);
            Connection conn = this.getConnection(insertSQLPart.getConnectionPoolName(), connList);
            this.setAutoCommitIfRequired(conn, false);
            PartitionTable partitionTable = new PartitionTable(conn, insertStmt);
            partitionTable.partitionAndRead();
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(4, node.getTableName(), "" + node.getContext().getStatistics().getTableExecutionId(node.getTableName()));
            this.taskNode.fireETLEngineExecutionEvent(evnt);
            String successMsg = MSG_MGR.getString("MSG_extractor_insert_success", new Long(partitionTable.getInsertCount()));
            this.taskNode.fireETLEngineLogEvent(successMsg, 20000);
            this.taskNode.getContext().getStatistics().setRowsInsertedCount(this.taskNode.getTableName(), partitionTable.getInsertCount());
        }
        catch (Exception ex) {
            String failureMsg = MSG_MGR.getString("MSG_LOADER_failed");
            node.fireETLEngineLogEvent(failureMsg, 10000);
            com.sun.sql.framework.utils.Logger.printThrowable(10000, LOG_CATEGORY, this, this.DN + failureMsg, ex);
            throw new ETLException(ex);
        }
        return "";
    }

    private long getStartOffset(BufferedDataInputStream stream) {
        try {
            stream.seek(0L);
            int i = 0;
            while (i++ < this.rowsToSkip) {
                this._streamTokenizer.skipLine(stream);
            }
            return stream.getPos();
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.SEVERE, null, ex);
            return -1L;
        }
    }

    public String fixEscapeSequence(String srcString) {
        if (srcString == null || srcString.length() < 2) {
            return srcString;
        }
        char[] srcArray = srcString.toCharArray();
        char[] tgtArray = (char[])srcArray.clone();
        Arrays.fill(tgtArray, ' ');
        int j = 0;
        for (int i = 0; i < srcArray.length; ++i) {
            int c = srcArray[i];
            if (i + 1 == srcArray.length) {
                tgtArray[j++] = c;
                break;
            }
            if (c == 92) {
                switch (srcArray[i + 1]) {
                    case 't': {
                        c = 9;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    case 'b': {
                        c = 8;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'f': {
                        c = 12;
                    }
                }
                ++i;
            }
            tgtArray[j++] = c;
        }
        return new String(tgtArray, 0, j);
    }

    private void initializeProperties(AttributeMap attrMap) {
        String lineSep = System.getProperty("line.separator");
        String recordDelimiter = (String)attrMap.get("RECORDDELIMITER").getAttributeValue();
        _lineSep = recordDelimiter != null ? this.fixEscapeSequence(recordDelimiter) : this.fixEscapeSequence(lineSep);
        StringTokenizer tokenizer = new StringTokenizer(_lineSep, " ");
        ArrayList<String> tmpList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tmpList.add(token);
        }
        this._lineSeps = tmpList.toArray(new String[0]);
        this._lineSepsChar = new char[tmpList.size()][];
        int I = tmpList.size();
        for (int i = 0; i < I; ++i) {
            this._lineSepsChar[i] = ((String)tmpList.get(i)).toCharArray();
        }
        fieldDelimiter = (String)attrMap.get("FIELDDELIMITER").getAttributeValue();
        this._fieldSepChar = fieldDelimiter != null && fieldDelimiter.length() != 0 ? fieldDelimiter.toCharArray() : new char[0];
        qualifier = (String)attrMap.get("QUALIFIER").getAttributeValue();
        if (qualifier != null && qualifier.length() != 0) {
            this._isQuoted = true;
            this._qualifierChar = this.fixEscapeSequence(qualifier).toCharArray();
        } else {
            this._qualifierChar = new char[0];
        }
        fileLocation = (String)attrMap.get("FILENAME").getAttributeValue();
        try {
            this.rowsToSkip = Integer.valueOf((String)attrMap.get("ROWSTOSKIP").getAttributeValue());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.colCount = Integer.parseInt((String)attrMap.get("COLUMNCOUNT").getAttributeValue());
        this._streamTokenizer = new CharStreamTokenizer(this._fieldSepChar, this._lineSepsChar, this._qualifierChar, this._isQuoted);
        String partitionSize = (String)attrMap.getAttributeValue(KEY_PARTITIONSIZE);
        try {
            this.partitions = Integer.parseInt(partitionSize);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String jobQ = (String)attrMap.getAttributeValue(KEY_JOBQUEUESIZE);
        try {
            this.jobQueueSize = Integer.parseInt(jobQ);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.consumerThread = Executors.newSingleThreadExecutor();
        this.jobQueue = new ArrayBlockingQueue<PreparedStatement>(this.jobQueueSize, true);
        this.preparedStmtPool = new ArrayBlockingQueue<PreparedStatement>(this.jobQueueSize);
        this.consumer = new BatchProcessingConsumer(this.partitions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BatchProcessingConsumer
    implements Callable<Long> {
        private AtomicInteger producerCount;

        public BatchProcessingConsumer(int producerCount) {
            this.producerCount = new AtomicInteger(producerCount);
        }

        @Override
        public Long call() throws Exception {
            long insertCount = 0L;
            block8: while (true) {
                try {
                    while (this.producerCount.get() != 0) {
                        PreparedStatement prepStmt = (PreparedStatement)Loader.this.jobQueue.take();
                        if (prepStmt == null) continue;
                        int[] rows = null;
                        try {
                            rows = prepStmt.executeBatch();
                            insertCount += (long)rows.length;
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        prepStmt.clearBatch();
                        try {
                            Loader.this.preparedStmtPool.put(prepStmt);
                            continue block8;
                        }
                        catch (Exception ex) {
                            prepStmt.close();
                        }
                    }
                    break;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            int I = Loader.this.jobQueue.size();
            for (int i = 0; i < I; ++i) {
                PreparedStatement prepStmt = (PreparedStatement)Loader.this.jobQueue.poll();
                if (prepStmt == null) continue;
                int[] rows = null;
                try {
                    rows = prepStmt.executeBatch();
                    insertCount += (long)rows.length;
                    prepStmt.close();
                    continue;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Consumer thread exiting...");
            return insertCount;
        }

        public void stopConsuming() {
            this.producerCount.decrementAndGet();
        }
    }

    private class PartitionReader
    implements Runnable {
        private long startOffset;
        private long endOffset;
        private BufferedDataInputStream dataStream;
        private Connection conn;
        private String statement;
        private PreparedStatement prepStmt;
        private int id;

        public PartitionReader(long start, long end, Connection conn, String stmt, int id) {
            try {
                this.startOffset = start;
                this.endOffset = end;
                this.conn = conn;
                this.statement = stmt;
                this.id = id;
                this.dataStream = new BufferedDataInputStream(Loader.this.FS.open(new File(fileLocation)), 8192);
                this.dataStream.seek(this.startOffset);
            }
            catch (Exception ex) {
                Logger.getLogger("global").log(Level.SEVERE, null, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long insertCount = 0L;
            System.out.println("Initializing Producer " + this.id + " ...");
            try {
                this.prepStmt = this.conn.prepareStatement(this.statement);
                long fileOffset = this.startOffset;
                int localBatchSize = 0;
                String insertStartMsg = MSG_MGR.getString("MSG_extractor_insert_attempt");
                Loader.this.taskNode.fireETLEngineLogEvent(insertStartMsg, 10000);
                String prepStmtMsg = MSG_MGR.getString("MSG_extractor_show_prep_stmt", this.statement);
                Loader.this.taskNode.fireETLEngineLogEvent(prepStmtMsg, 10000);
                if (this.prepStmt == null) {
                    String errMsg = MSG_MGR.getString("MSG_extractor_invalid_insert");
                    Loader.this.taskNode.fireETLEngineLogEvent(errMsg, 10000);
                    throw new BaseException("Invalid insert statement.");
                }
                while (-1L != fileOffset && fileOffset < this.endOffset) {
                    String[] results = Loader.this._streamTokenizer.readAndSplitLine(this.dataStream, Loader.this.colCount, false);
                    for (int i = 1; i <= Loader.this.colCount; ++i) {
                        this.prepStmt.setObject(i, results[i - 1]);
                    }
                    try {
                        if (batchSize > 1) {
                            this.prepStmt.addBatch();
                            if (++localBatchSize == batchSize) {
                                String engineState = (String)Loader.this.taskNode.getContext().getValue("engineState");
                                if (engineState != null && engineState.trim().equalsIgnoreCase("not-active")) {
                                    this.prepStmt.close();
                                    throw new ETLException("Engine is no longer active");
                                }
                                Loader.this.jobQueue.put(this.prepStmt);
                                this.prepStmt = (PreparedStatement)Loader.this.preparedStmtPool.take();
                                if (null == this.prepStmt) {
                                    this.prepStmt = this.conn.prepareStatement(this.statement);
                                }
                                localBatchSize = 0;
                            }
                        } else {
                            this.prepStmt.executeUpdate();
                            ++insertCount;
                        }
                    }
                    catch (Exception se) {
                        String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", se.getMessage());
                        com.sun.sql.framework.utils.Logger.printThrowable(40000, LOG_CATEGORY, null, errMsg, se);
                        Loader.this.taskNode.fireETLEngineLogEvent(errMsg, 40000);
                    }
                    fileOffset = this.dataStream.getPos();
                }
                if (batchSize > 1) {
                    Loader.this.consumer.stopConsuming();
                    if (localBatchSize != 0) {
                        Loader.this.jobQueue.put(this.prepStmt);
                    }
                }
                System.out.println("Exiting Producer " + this.id);
            }
            catch (Exception ex) {
                Logger.getLogger("global").log(Level.SEVERE, null, ex);
            }
            finally {
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (Exception ex) {
                        this.conn = null;
                    }
                }
            }
        }
    }

    private class PartitionTable {
        private ExecutorService partitionReaderPool;
        private Connection conn;
        private String sqlStmt;
        private long insertCount = 0L;

        public PartitionTable(Connection conn, String stmt) {
            this.conn = conn;
            this.sqlStmt = stmt;
        }

        public void partitionAndRead() throws Exception {
            long fileLength;
            long approxPartitionSize = fileLength = FileUtil.getLength((File)new File(fileLocation));
            if (fileLength > 8192L) {
                approxPartitionSize = fileLength / (long)Loader.this.partitions;
            }
            BufferedDataInputStream dataStream = new BufferedDataInputStream(Loader.this.FS.open(new File(fileLocation)), 8192);
            this.partitionReaderPool = Executors.newFixedThreadPool(Loader.this.partitions);
            Future<Long> result = Loader.this.consumerThread.submit(Loader.this.consumer);
            long offset = Loader.this.getStartOffset(dataStream);
            for (int i = 0; i < Loader.this.partitions; ++i) {
                long start = offset;
                if ((offset += approxPartitionSize) > fileLength) {
                    offset = fileLength;
                } else {
                    dataStream.seek(offset);
                    Loader.this._streamTokenizer.skipLine(dataStream);
                    offset = dataStream.getPos();
                }
                PartitionReader reader = new PartitionReader(start, offset, this.conn, this.sqlStmt, i + 1);
                this.partitionReaderPool.submit(reader);
            }
            this.insertCount += result.get().longValue();
            try {
                this.conn.commit();
            }
            catch (SQLException ex) {
                this.insertCount = 0L;
            }
        }

        public long getInsertCount() {
            return this.insertCount;
        }
    }
}

