/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;

public class VarBinaryType
extends BaseDataType
implements Serializable,
Comparator,
DataType.NonFixedPrecision {
    private int _length = 0;
    private static final long serialVersionUID = -7647413688800437403L;

    public VarBinaryType() {
        this(1);
    }

    public VarBinaryType(int length) {
        this.setLength(length);
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getColumnDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public int getPrecision() {
        return this._length;
    }

    public boolean accepts(Object value) {
        return true;
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        byte[] val = (byte[])value;
        if (val.length == 0) {
            return new byte[]{-128};
        }
        byte last = val[val.length - 1];
        if (last == 127) {
            byte[] newval = new byte[val.length + 1];
            System.arraycopy(val, 0, newval, 0, val.length);
            newval[val.length] = -128;
            return newval;
        }
        byte[] newval = new byte[val.length];
        System.arraycopy(val, 0, newval, 0, val.length - 1);
        newval[val.length - 1] = (byte)(last + 1);
        return newval;
    }

    public Object convert(Object value) throws AxionException {
        if (value instanceof byte[]) {
            if (((byte[])value).length <= this._length) {
                return (byte[])value;
            }
            throw new AxionException(22001);
        }
        if (null == value) {
            return null;
        }
        if (value instanceof Blob) {
            try {
                return this.convert(((Blob)value).getBytes(1L, (int)((Blob)value).length()));
            }
            catch (Exception e) {
                throw new AxionException(e);
            }
        }
        if (value instanceof Clob) {
            try {
                return this.convert(((Clob)value).getSubString(1L, (int)((Clob)value).length()));
            }
            catch (Exception e) {
                throw new AxionException(e);
            }
        }
        return String.valueOf(value).getBytes();
    }

    public byte[] toByteArray(Object value) throws AxionException {
        return (byte[])this.convert(value);
    }

    public int getJdbcType() {
        return -3;
    }

    public DataType makeNewInstance() {
        return new VarBinaryType();
    }

    public Object read(DataInput in) throws IOException {
        int length = in.readInt();
        if (-1 == length) {
            return null;
        }
        if (length > this._length) {
            throw new IOException("Record length exceeds length for this binary type instance.");
        }
        byte[] data = new byte[length];
        in.readFully(data);
        return data;
    }

    public void write(Object value, DataOutput out) throws IOException {
        try {
            byte[] val = (byte[])this.convert(value);
            if (null == val) {
                out.writeInt(-1);
            } else {
                out.writeInt(val.length);
                out.write(val);
            }
        }
        catch (AxionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String toString(Object value) {
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return null == value ? null : value.toString();
    }

    public Comparator getComparator() {
        return this;
    }

    public int compare(Object a, Object b) throws ClassCastException {
        return this.compare((byte[])a, (byte[])b);
    }

    public void setPrecision(int newSize) {
        this._length = newSize;
    }

    private int compare(byte[] left, byte[] right) {
        for (int i = 0; i < left.length; ++i) {
            if (i >= right.length) {
                return 1;
            }
            if (left[i] < right[i]) {
                return -1;
            }
            if (left[i] <= right[i]) continue;
            return 1;
        }
        return left.length < right.length ? -1 : 0;
    }
}

