/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.axiondb.types.FileLobLocator;
import org.axiondb.types.LobLocator;
import org.axiondb.types.LobLocatorFactory;
import org.axiondb.util.ExceptionConverter;

public class FileLobLocatorFactory
implements LobLocatorFactory {
    private int _counter = new Random().nextInt();
    private static final String _LOB_PREFIX = "LOB";
    private static final String _LOB_SUFFIX = ".LOB";
    private static final long serialVersionUID = 1730401347993196339L;

    public void write(LobLocator locator, DataOutput out) throws IOException {
        ((FileLobLocator)locator).write(out);
    }

    public LobLocator read(DataInput in) throws IOException {
        return new FileLobLocator(in.readUTF(), in.readUTF());
    }

    public LobLocator makeLobLocator(File parentdir) {
        try {
            File dir = this.getNextLobDir(parentdir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = File.createTempFile(_LOB_PREFIX, _LOB_SUFFIX, dir);
            return new FileLobLocator(file);
        }
        catch (IOException e) {
            throw ExceptionConverter.convertToRuntimeException(e);
        }
    }

    private File getNextLobDir(File parentdir) {
        return new File(parentdir, String.valueOf(Math.abs(this._counter++ % 1000)));
    }
}

