/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.axiondb.AxionException;
import org.axiondb.jdbc.AbstractAxionClob;
import org.axiondb.types.LobSource;
import org.axiondb.util.ExceptionConverter;
import org.axiondb.util.Utf8InputStreamConverter;

public class ClobSource
extends AbstractAxionClob {
    private LobSource _lob = null;

    public ClobSource(LobSource lob) {
        this.setLobSource(lob);
    }

    public void setLobSource(LobSource lob) {
        this._lob = lob;
    }

    protected InputStream getUtf8Stream() throws AxionException {
        return this._lob.getInputStream();
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new Utf8InputStreamConverter(this.getUtf8Stream(), "US-ASCII");
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.toString());
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            return new BufferedReader(new InputStreamReader(this.getUtf8Stream(), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.toString());
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.setUtf8Stream(pos);
    }

    public OutputStream setUtf8Stream(long pos) throws SQLException {
        try {
            return this._lob.setOutputStream(pos);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public long length() throws SQLException {
        try {
            return this._lob.length();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public void truncate(long length) throws SQLException {
        try {
            this._lob.truncate(length);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public void free() throws SQLException {
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new SQLException("Unsupported.");
    }
}

