/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;
import org.axiondb.types.StringClob;

public class AnyType
extends BaseDataType {
    public static final AnyType INSTANCE = new AnyType();

    public DataType makeNewInstance() {
        return new AnyType();
    }

    public boolean accepts(Object value) {
        return true;
    }

    public Object convert(Object value) {
        return value;
    }

    public Object read(DataInput in) throws IOException {
        throw new IOException("This type is not meant to be saved.");
    }

    public void write(Object value, DataOutput out) throws IOException {
        throw new IOException("This type is not meant to be saved.");
    }

    public int getColumnDisplaySize() {
        return 0;
    }

    public int getJdbcType() {
        return 1111;
    }

    public String getPreferredValueClassName() {
        return "java.lang.String";
    }

    public boolean supportsSuccessor() {
        return false;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    protected Number toNumber(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        return new Integer(this.toInt(value));
    }

    public boolean toBoolean(Object value) throws AxionException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if ("true".equals(this.toString(value))) {
            return true;
        }
        if ("false".equals(this.toString(value))) {
            return false;
        }
        throw new AxionException("Can't convert " + value + " to a boolean value, expected 'true' or 'false'.", 22018);
    }

    public byte toByte(Object value) throws AxionException {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        try {
            return Byte.parseByte(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new AxionException("Can't convert " + value + " to byte.", 22018);
        }
    }

    public byte[] toByteArray(Object value) throws AxionException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        try {
            return this.toString(value).getBytes();
        }
        catch (RuntimeException e) {
            throw new AxionException("Can't convert " + value + " to byte array.", 22018);
        }
    }

    public double toDouble(Object value) throws AxionException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new AxionException("Can't convert " + value + " to double.", 22018);
        }
    }

    public float toFloat(Object value) throws AxionException {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        try {
            return Float.parseFloat(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new AxionException("Can't convert " + value + " to float.", 22018);
        }
    }

    public int toInt(Object value) throws AxionException {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new AxionException("Can't convert " + value + " to int.", 22018);
        }
    }

    public long toLong(Object value) throws AxionException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Time) {
            return ((Time)value).getTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).getTime();
        }
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new AxionException("Can't convert " + value + " to long.", 22018);
        }
    }

    public short toShort(Object value) throws AxionException {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        try {
            return Short.parseShort(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new AxionException("Can't convert " + value + " to short.", 22018);
        }
    }

    public String toString(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public Date toDate(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        throw new AxionException("Can't convert " + value + " to Time.", 22018);
    }

    public Time toTime(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Number) {
            return new Time(((Number)value).longValue());
        }
        throw new AxionException("Can't convert " + value + " to Time.", 22018);
    }

    public Timestamp toTimestamp(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        throw new AxionException("Can't convert " + value + " to Timestamp.", 22018);
    }

    public Clob toClob(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Clob) {
            return (Clob)value;
        }
        return new StringClob(this.toString(value));
    }

    public Blob toBlob(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Blob) {
            return (Blob)value;
        }
        throw new AxionException("Can't convert " + value + " to Blob.", 22018);
    }
}

