/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.tools;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.engine.DiskDatabase;

public class Defrag {
    private static Logger _log = Logger.getLogger(Defrag.class.getName());

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Defragments a database file");
            System.err.println("Arguments: <database-directory>");
        } else {
            try {
                Defrag.defragDatabase(args[0]);
            }
            catch (Exception e) {
                _log.log(Level.FINE, "Exception while defragmenting database: ", e);
                System.err.println("Fail to defrag...");
            }
        }
    }

    public static void defragDatabase(String databaseDirectory) throws Exception {
        Defrag.defragDatabase(new File(databaseDirectory));
    }

    public static void defragDatabase(File databaseDirectory) throws Exception {
        DiskDatabase db = new DiskDatabase(databaseDirectory);
        db.defrag();
        db.shutdown();
    }
}

