/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.ConstraintViolationException;
import org.axiondb.DataType;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowDecoratorIterator;
import org.axiondb.Selectable;
import org.axiondb.Transaction;
import org.axiondb.TransactionManager;
import org.axiondb.engine.rowiterators.EmptyRowIterator;
import org.axiondb.engine.rowiterators.RowIteratorRowDecoratorIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.jdbc.AxionResultSetMetaData;
import org.axiondb.util.ExceptionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionResultSet
implements ResultSet {
    private static final int DIR_FORWARD = 1;
    private static final int DIR_REVERSE = -1;
    private static final int DIR_UNKNOWN = 0;
    private static final BigDecimal NULL_BIGDECIMAL = null;
    private static final Blob NULL_BLOB = null;
    private static final boolean NULL_BOOLEAN = false;
    private static final byte NULL_BYTE = 0;
    private static final byte[] NULL_BYTES = null;
    private static final Clob NULL_CLOB = null;
    private static final Date NULL_DATE = null;
    private static final double NULL_DOUBLE = 0.0;
    private static final float NULL_FLOAT = 0.0f;
    private static final int NULL_INT = 0;
    private static final long NULL_LONG = 0L;
    private static final Reader NULL_READER = null;
    private static final short NULL_SHORT = 0;
    private static final InputStream NULL_STREAM = null;
    private static final String NULL_STRING = null;
    private static final Time NULL_TIME = null;
    private static final Timestamp NULL_TIMESTAMP = null;
    private static final URL NULL_URL = null;
    private static final int USE_DEFAULT_SCALE = Integer.MIN_VALUE;
    protected RowDecoratorIterator _rows = null;
    private boolean _afterLast = false;
    private boolean _closed = false;
    private RowDecorator _currentRow = null;
    private int _currentRowIndex = 0;
    private boolean _insertMode = false;
    private Row _insertUpdateRow = null;
    private int _lastDir = 0;
    private int _maxRows = 0;
    private ResultSetMetaData _meta = null;
    private Selectable[] _selected = null;
    private Statement _stmt = null;
    private Transaction _transaction = null;
    private TransactionManager _transactionManager = null;
    private Object _updateLock = new Object();
    private SQLWarning _warning = null;
    private boolean _wasNull = false;

    public static ResultSet createEmptyResultSet(Statement stmt) {
        return new AxionResultSet(new RowIteratorRowDecoratorIterator(EmptyRowIterator.INSTANCE, new RowDecorator(Collections.EMPTY_MAP)), new Selectable[0], stmt);
    }

    public AxionResultSet(RowDecoratorIterator rows, Selectable[] selected) {
        this(rows, selected, null);
    }

    public AxionResultSet(RowDecoratorIterator rows, Selectable[] selected, Statement stmt) {
        this._rows = rows;
        this._selected = selected;
        this._meta = new AxionResultSetMetaData(selected);
        this.setStatement(stmt);
    }

    protected AxionResultSet() {
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.assertOpen();
        this.assertScrollable();
        if (row < 0) {
            if (row == -1) {
                return this.last();
            }
            this.afterLast();
            return this.relative(row);
        }
        this.beforeFirst();
        return this.relative(row);
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.assertOpen();
        this.assertScrollable();
        this.clearInsertOrUpdateIfAny();
        try {
            this._rows.reset();
            this._currentRowIndex = 0;
            this._afterLast = false;
            this._lastDir = 1;
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        catch (RuntimeException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.assertOpen();
        this.assertUpdateable();
        this.assertNotInInsertMode();
        this.clearUpdateRow();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    @Override
    public void close() throws SQLException {
        if (null != this._transactionManager && null != this._transaction) {
            try {
                this._transactionManager.commitTransaction(this._transaction);
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
            this._transactionManager = null;
            this._transaction = null;
        }
        this._closed = true;
        this._selected = null;
        this._currentRow = null;
        this._insertUpdateRow = null;
        this._warning = null;
        this._updateLock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        this.assertOpen();
        Object object = this._updateLock;
        synchronized (object) {
            this.assertUpdateable();
            this.assertNotInInsertMode();
            this.assertCurrentRow();
            try {
                boolean lastRowDeleted = this.isLast();
                this._rows.getIterator().remove();
                this.clearUpdateRow();
                if (lastRowDeleted) {
                    this._afterLast = true;
                } else {
                    --this._currentRowIndex;
                }
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
            catch (UnsupportedOperationException e) {
                throw new SQLException("Cannot delete row: table/view is not updateable.");
            }
        }
    }

    @Override
    public int findColumn(String colName) throws SQLException {
        this.assertOpen();
        return this.getResultSetIndexForColumnName(colName);
    }

    @Override
    public boolean first() throws SQLException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        Clob clob = this.getClob(i);
        if (null == clob) {
            return NULL_STREAM;
        }
        return clob.getAsciiStream();
    }

    @Override
    public InputStream getAsciiStream(String colName) throws SQLException {
        return this.getAsciiStream(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_BIGDECIMAL;
        }
        try {
            return this.getDataType(i).toBigDecimal(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_BIGDECIMAL;
        }
        try {
            BigInteger bigint = this.getDataType(i).toBigInteger(value);
            if (null == bigint) {
                return NULL_BIGDECIMAL;
            }
            return new BigDecimal(bigint, scale);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String colName) throws SQLException {
        return this.getBigDecimal(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public BigDecimal getBigDecimal(String colName, int scale) throws SQLException {
        return this.getBigDecimal(this.getResultSetIndexForColumnName(colName), scale);
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        Blob blob = this.getBlob(i);
        if (null == blob) {
            return NULL_STREAM;
        }
        return blob.getBinaryStream();
    }

    @Override
    public InputStream getBinaryStream(String colName) throws SQLException {
        return this.getBinaryStream(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_BLOB;
        }
        try {
            return this.getDataType(i).toBlob(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return false;
        }
        try {
            return this.getDataType(i).toBoolean(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public boolean getBoolean(String colName) throws SQLException {
        return this.getBoolean(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public byte getByte(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return 0;
        }
        try {
            return this.getDataType(i).toByte(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public byte getByte(String colName) throws SQLException {
        return this.getByte(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_BYTES;
        }
        try {
            return this.getDataType(i).toByteArray(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public byte[] getBytes(String colName) throws SQLException {
        return this.getBytes(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        Clob clob = this.getClob(i);
        if (null == clob) {
            return NULL_READER;
        }
        return clob.getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String colName) throws SQLException {
        return this.getCharacterStream(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_CLOB;
        }
        try {
            return this.getDataType(i).toClob(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._stmt != null ? this._stmt.getResultSetConcurrency() : 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Date getDate(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_DATE;
        }
        try {
            return this.getDataType(i).toDate(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Date getDate(String colName) throws SQLException {
        return this.getDate(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Date getDate(String colName, Calendar cal) throws SQLException {
        return this.getDate(this.getResultSetIndexForColumnName(colName), cal);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return 0.0;
        }
        try {
            return this.getDataType(i).toDouble(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public double getDouble(String colName) throws SQLException {
        return this.getDouble(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public float getFloat(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return 0.0f;
        }
        try {
            return this.getDataType(i).toFloat(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public float getFloat(String colName) throws SQLException {
        return this.getFloat(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public int getInt(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return 0;
        }
        try {
            return this.getDataType(i).toInt(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public int getInt(String colName) throws SQLException {
        return this.getInt(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public long getLong(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return 0L;
        }
        try {
            return this.getDataType(i).toLong(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public long getLong(String colName) throws SQLException {
        return this.getLong(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._meta;
    }

    @Override
    public Object getObject(int i) throws SQLException {
        return this.getValue(i);
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Object getObject(String colName) throws SQLException {
        return this.getObject(this.getResultSetIndexForColumnName(colName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.getResultSetIndexForColumnName(colName), map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this._currentRow.getRowIndex() + 1;
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public short getShort(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return 0;
        }
        try {
            return this.getDataType(i).toShort(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public short getShort(String colName) throws SQLException {
        return this.getShort(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    @Override
    public String getString(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_STRING;
        }
        try {
            return this.getDataType(i).toString(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public String getString(String colName) throws SQLException {
        return this.getString(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Time getTime(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_TIME;
        }
        try {
            return this.getDataType(i).toTime(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Time getTime(String colName) throws SQLException {
        return this.getTime(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Time getTime(String colName, Calendar cal) throws SQLException {
        return this.getTime(this.getResultSetIndexForColumnName(colName), cal);
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_TIMESTAMP;
        }
        try {
            return this.getDataType(i).toTimestamp(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Timestamp getTimestamp(String colName) throws SQLException {
        return this.getTimestamp(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public Timestamp getTimestamp(String colName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getResultSetIndexForColumnName(colName), cal);
    }

    @Override
    public int getType() throws SQLException {
        return this._stmt != null ? this._stmt.getResultSetType() : 1003;
    }

    @Override
    public InputStream getUnicodeStream(int i) throws SQLException {
        String val = this.getString(i);
        if (null == val) {
            return NULL_STREAM;
        }
        try {
            return new ByteArrayInputStream(val.getBytes("UnicodeBig"));
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public InputStream getUnicodeStream(String colName) throws SQLException {
        return this.getUnicodeStream(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public URL getURL(int i) throws SQLException {
        Object value = this.getValue(i);
        if (null == value) {
            return NULL_URL;
        }
        try {
            return this.getDataType(i).toURL(value);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public URL getURL(String colName) throws SQLException {
        return this.getURL(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        this.assertOpen();
        Object object = this._updateLock;
        synchronized (object) {
            this.assertUpdateable();
            this.assertInInsertMode();
            this.assertUpdateRowExists();
            this.assertCurrentRow();
            try {
                this._rows.getIterator().add(new SimpleRow(this._insertUpdateRow));
            }
            catch (AxionException e) {
                this.handleExceptionOnInsertUpdate(e, "Cannot insert row.");
            }
            catch (UnsupportedOperationException e) {
                throw new SQLException("Cannot insert row - table/view is not updateable.");
            }
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return !this._rows.getIterator().isEmpty() && this._afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return !this._rows.getIterator().isEmpty() && 0 == this._currentRowIndex;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return !this._rows.getIterator().isEmpty() && 1 == this._currentRowIndex;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.assertOpen();
        boolean isLastRow = false;
        if (!this._rows.getIterator().isEmpty() && !this._afterLast && this._currentRowIndex != 0) {
            isLastRow = !this._rows.hasNext();
        }
        return isLastRow;
    }

    @Override
    public boolean last() throws SQLException {
        this.assertOpen();
        this.assertScrollable();
        this._lastDir = 1;
        this.clearInsertOrUpdateIfAny();
        RowDecorator row = null;
        try {
            row = this._rows.last();
            if (row != null) {
                this._currentRow = row;
                this._currentRowIndex = this._currentRow.getRowIndex() + 1;
                return true;
            }
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.assertOpen();
        this.assertUpdateable();
        this.clearInsertRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.assertOpen();
        this.assertUpdateable();
        this.createInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        this.assertOpen();
        this.clearInsertOrUpdateIfAny();
        if (this._maxRows > 0 && this._currentRowIndex >= this._maxRows) {
            this._afterLast = true;
            return false;
        }
        boolean result = false;
        try {
            result = this._rows.hasNext();
        }
        catch (RuntimeException re) {
            throw ExceptionConverter.convert(re);
        }
        if (result) {
            try {
                if (-1 == this._lastDir) {
                    this._rows.next();
                }
                this._lastDir = 1;
                if (this._rows.hasNext()) {
                    this._afterLast = false;
                    this._currentRow = this._rows.next();
                    this._currentRowIndex = this._currentRow.getRowIndex() + 1;
                }
                ++this._currentRowIndex;
                this._afterLast = true;
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
        } else {
            if (!this._afterLast) {
                ++this._currentRowIndex;
            }
            this._afterLast = true;
        }
        return result;
    }

    @Override
    public boolean previous() throws SQLException {
        this.assertOpen();
        this.assertScrollable();
        this.clearInsertOrUpdateIfAny();
        if (this._currentRowIndex <= 0) {
            return false;
        }
        boolean result = false;
        try {
            result = this._rows.hasPrevious();
        }
        catch (RuntimeException re) {
            throw ExceptionConverter.convert(re);
        }
        if (result) {
            try {
                if (this._afterLast && this._rows.hasCurrent()) {
                    this._currentRow = this._rows.current();
                    this._currentRowIndex = this._currentRow.getRowIndex() + 1;
                }
                if (this.isFirst()) {
                    this.beforeFirst();
                    this._afterLast = false;
                    return false;
                }
                if (!this._afterLast && 1 == this._lastDir) {
                    this._rows.previous();
                }
                this._lastDir = -1;
                this._currentRow = this._rows.previous();
                this._currentRowIndex = this._currentRow.getRowIndex() + 1;
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
        } else {
            this.beforeFirst();
        }
        this._afterLast = false;
        return result;
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.assertOpen();
        this.assertScrollable();
        if (rows < 0) {
            return this.previous(-1 * rows);
        }
        return this.next(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
    }

    public void setMaxRows(int max) {
        this._maxRows = max;
    }

    public void setTransaction(TransactionManager manager, Transaction transaction) {
        this._transactionManager = manager;
        this._transaction = transaction;
    }

    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new SQLException("updateArray is currently not supported");
    }

    @Override
    public void updateArray(String colName, Array arg1) throws SQLException {
        this.updateArray(this.getResultSetIndexForColumnName(colName), arg1);
    }

    @Override
    public void updateAsciiStream(int i, InputStream in, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public void updateAsciiStream(String colName, InputStream in, int length) throws SQLException {
        this.updateAsciiStream(this.getResultSetIndexForColumnName(colName), in, length);
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateBigDecimal(String colName, BigDecimal value) throws SQLException {
        this.updateBigDecimal(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateBinaryStream(int i, InputStream value, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public void updateBinaryStream(String colName, InputStream value, int length) throws SQLException {
        this.updateBinaryStream(this.getResultSetIndexForColumnName(colName), value, length);
    }

    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new SQLException("updateBlob is currently not supported");
    }

    @Override
    public void updateBlob(String colName, Blob arg1) throws SQLException {
        this.updateBlob(this.getResultSetIndexForColumnName(colName), arg1);
    }

    @Override
    public void updateBoolean(int i, boolean value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateBoolean(String colName, boolean value) throws SQLException {
        this.updateBoolean(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateByte(int i, byte value) throws SQLException {
        this.setValue(i, new Byte(value), Integer.MIN_VALUE);
    }

    @Override
    public void updateByte(String colName, byte value) throws SQLException {
        this.updateByte(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateBytes(int i, byte[] value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateBytes(String colName, byte[] value) throws SQLException {
        this.updateBytes(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateCharacterStream(int i, Reader value, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public void updateCharacterStream(String colName, Reader value, int length) throws SQLException {
        this.updateCharacterStream(this.getResultSetIndexForColumnName(colName), value, length);
    }

    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new SQLException("updateClob is currently not supported");
    }

    @Override
    public void updateClob(String colName, Clob arg1) throws SQLException {
        this.updateClob(this.getResultSetIndexForColumnName(colName), arg1);
    }

    @Override
    public void updateDate(int i, Date value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateDate(String colName, Date value) throws SQLException {
        this.updateDate(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateDouble(int i, double value) throws SQLException {
        this.setValue(i, new Double(value), Integer.MIN_VALUE);
    }

    @Override
    public void updateDouble(String colName, double value) throws SQLException {
        this.updateDouble(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateFloat(int i, float value) throws SQLException {
        this.setValue(i, new Float(value), Integer.MIN_VALUE);
    }

    @Override
    public void updateFloat(String colName, float value) throws SQLException {
        this.updateFloat(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateInt(int i, int value) throws SQLException {
        this.setValue(i, new Integer(value), Integer.MIN_VALUE);
    }

    @Override
    public void updateInt(String colName, int value) throws SQLException {
        this.updateInt(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateLong(int i, long value) throws SQLException {
        this.setValue(i, new Long(value), Integer.MIN_VALUE);
    }

    @Override
    public void updateLong(String colName, long value) throws SQLException {
        this.updateLong(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateNull(int i) throws SQLException {
        this.setValue(i, null, Integer.MIN_VALUE);
    }

    @Override
    public void updateNull(String colName) throws SQLException {
        this.updateNull(this.getResultSetIndexForColumnName(colName));
    }

    @Override
    public void updateObject(int i, Object value) throws SQLException {
        this.updateObject(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateObject(int i, Object value, int scale) throws SQLException {
        this.setValue(i, value, scale);
    }

    @Override
    public void updateObject(String colName, Object value) throws SQLException {
        this.updateObject(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateObject(String colName, Object value, int scale) throws SQLException {
        this.updateObject(this.getResultSetIndexForColumnName(colName), value, scale);
    }

    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new SQLException("updateRef is currently not supported");
    }

    @Override
    public void updateRef(String colName, Ref arg1) throws SQLException {
        this.updateRef(this.getResultSetIndexForColumnName(colName), arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        this.assertOpen();
        Object object = this._updateLock;
        synchronized (object) {
            this.assertUpdateable();
            this.assertNotInInsertMode();
            this.assertUpdateRowExists();
            this.assertCurrentRow();
            try {
                this._rows.getIterator().set(this._insertUpdateRow);
                this._currentRow = this._rows.current();
            }
            catch (AxionException e) {
                this.handleExceptionOnInsertUpdate(e, "Cannot update row.");
            }
            catch (UnsupportedOperationException e) {
                throw new SQLException("Cannot update row: table/view is not updateable.");
            }
            this._insertUpdateRow = null;
        }
    }

    @Override
    public void updateShort(int i, short value) throws SQLException {
        this.setValue(i, new Short(value), Integer.MIN_VALUE);
    }

    @Override
    public void updateShort(String colName, short value) throws SQLException {
        this.updateShort(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateString(int i, String value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateString(String colName, String value) throws SQLException {
        this.updateString(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateTime(int i, Time value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateTime(String colName, Time value) throws SQLException {
        this.updateTime(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public void updateTimestamp(int i, Timestamp value) throws SQLException {
        this.setValue(i, value, Integer.MIN_VALUE);
    }

    @Override
    public void updateTimestamp(String colName, Timestamp value) throws SQLException {
        this.updateTimestamp(this.getResultSetIndexForColumnName(colName), value);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    protected void setStatement(Statement stmt) {
        this._stmt = stmt;
    }

    private final void assertCurrentRow() throws SQLException {
        if (null == this._currentRow) {
            throw new SQLException("No current row");
        }
    }

    private final void assertInInsertMode() throws SQLException {
        if (!this._insertMode) {
            throw new SQLException("Not in insert mode - operation failed.");
        }
    }

    private final void assertNotInInsertMode() throws SQLException {
        if (this._insertMode) {
            throw new SQLException("In insert mode - operation failed.");
        }
    }

    private final void assertOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Already closed");
        }
    }

    private final void assertScrollable() throws SQLException {
        if (1003 == this.getType()) {
            throw new SQLException("Invalid cursor movement request - ResultSet is forward-only.");
        }
    }

    private final void assertUpdateable() throws SQLException {
        if (1008 != this.getConcurrency()) {
            throw new SQLException("Not an updateable ResultSet - operation failed.");
        }
    }

    private final void assertUpdateRowExists() throws SQLException {
        if (null == this._insertUpdateRow) {
            throw new SQLException("No update row");
        }
    }

    private void clearInsertOrUpdateIfAny() throws SQLException {
        if (this._insertUpdateRow != null) {
            if (this._insertMode) {
                this.moveToCurrentRow();
            } else {
                this.cancelRowUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInsertRow() {
        Object object = this._updateLock;
        synchronized (object) {
            this.clearUpdateRow();
            this._insertMode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearUpdateRow() {
        Object object = this._updateLock;
        synchronized (object) {
            this._insertUpdateRow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row createInsertRow() throws SQLException {
        Object object = this._updateLock;
        synchronized (object) {
            this._insertMode = true;
            this._insertUpdateRow = new SimpleRow(this._meta.getColumnCount());
        }
        return this._insertUpdateRow;
    }

    private DataType getDataType(int num) throws SQLException {
        Selectable sel = this._selected[num - 1];
        return sel.getDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row getOrCreateUpdateRow() throws SQLException {
        this.assertCurrentRow();
        Object object = this._updateLock;
        synchronized (object) {
            if (null == this._insertUpdateRow) {
                this._insertUpdateRow = new SimpleRow(this._currentRow.getRow());
            }
            return this._insertUpdateRow;
        }
    }

    private int getResultSetIndexForColumnName(String columnname) throws SQLException {
        ColumnIdentifier id = null;
        columnname = columnname.toUpperCase();
        for (int i = 0; i < this._selected.length; ++i) {
            if (!(this._selected[i] instanceof ColumnIdentifier) || !columnname.equals((id = (ColumnIdentifier)this._selected[i]).getName()) && !columnname.equals(id.getAlias())) continue;
            return i + 1;
        }
        throw new SQLException("No column named " + columnname + " found.");
    }

    private Object getValue(int num) throws SQLException {
        this.assertOpen();
        Object val = null;
        if (this._insertMode) {
            val = this._insertUpdateRow.get(num - 1);
        } else {
            this.assertCurrentRow();
            Selectable sel = this._selected[num - 1];
            try {
                val = sel.evaluate(this._currentRow);
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
        }
        this._wasNull = null == val;
        return val;
    }

    private void handleExceptionOnInsertUpdate(AxionException e, String defaultMessage) throws SQLException {
        if (!"99999".equals(e.getSQLState())) {
            if (e instanceof ConstraintViolationException && "NOT NULL".equals(((ConstraintViolationException)e).getConstraintType())) {
                throw new SQLException(e.getMessage(), "22004");
            }
            throw new SQLException(e.getMessage(), e.getSQLState());
        }
        throw new SQLException(defaultMessage);
    }

    private boolean next(int n) throws SQLException {
        boolean result = null != this._currentRow;
        for (int i = 0; i < n; ++i) {
            result = this.next();
        }
        return result;
    }

    private boolean previous(int n) throws SQLException {
        boolean result = null != this._currentRow;
        for (int i = 0; i < n; ++i) {
            result = this.previous();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(int num, Object value, int scale) throws SQLException {
        this.assertUpdateable();
        DataType type = this.getDataType(num);
        Object object = this._updateLock;
        synchronized (object) {
            Row row = this._insertMode ? this._insertUpdateRow : this.getOrCreateUpdateRow();
            try {
                row.set(num - 1, type.convert(value));
            }
            catch (UnsupportedOperationException e) {
                ExceptionConverter.convert(e);
            }
            catch (AxionException e) {
                ExceptionConverter.convert(e);
            }
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

