/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.axiondb.io.AxionOutputStream;

public class BufferedDataOutputStream
extends DataOutputStream {
    public BufferedDataOutputStream(AxionOutputStream out) throws IOException {
        this(out, 512);
    }

    public BufferedDataOutputStream(AxionOutputStream out, int bufferSize) throws IOException {
        super(new Buffer(new PositionCache(out), bufferSize));
    }

    public long getPos() throws IOException {
        return ((Buffer)this.out).getPosition();
    }

    public void seek(long pos) throws IOException {
        ((Buffer)this.out).seek(pos);
    }

    private static class PositionCache
    extends FilterOutputStream {
        long position;

        public PositionCache(AxionOutputStream out) throws IOException {
            super(out);
            this.position = out.getPos();
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public void seek(long pos) throws IOException {
            ((AxionOutputStream)this.out).seek(pos);
            this.position = pos;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
        }
    }

    private static class Buffer
    extends BufferedOutputStream {
        private int position;

        public Buffer(PositionCache out, int bufferSize) throws IOException {
            super(out, bufferSize);
        }

        public void flush() throws IOException {
            super.flush();
            this.position = 0;
        }

        public long getPosition() throws IOException {
            return ((PositionCache)this.out).getPos() + (long)this.position;
        }

        public void seek(long desired) throws IOException {
            long start = ((PositionCache)this.out).getPos();
            long current = start + (long)this.position;
            if (desired >= start && desired < start + (long)this.buf.length) {
                this.position = (int)((long)this.position + (desired - current));
            } else {
                if (this.count > 0) {
                    this.flush();
                }
                ((PositionCache)this.out).seek(desired);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len >= this.buf.length) {
                this.flush();
                this.out.write(b, off, len);
                this.position = 0;
                return;
            }
            if (len > this.buf.length - this.count) {
                this.flush();
                this.position = 0;
            }
            System.arraycopy(b, off, this.buf, this.position, len);
            this.position += len;
            if (this.position > this.count) {
                this.count = this.position;
            }
        }

        public void write(int b) throws IOException {
            if (this.count >= this.buf.length) {
                super.write(b);
                this.position = 1;
            } else {
                this.buf[this.position++] = (byte)b;
                if (this.position > this.count) {
                    this.count = this.position;
                }
            }
        }
    }
}

