/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.util.ValuePool;

public class SignFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new IntegerType();

    public SignFunction() {
        super("SIGN");
    }

    public ConcreteFunction makeNewInstance() {
        return new SignFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        DataType type = sel.getDataType();
        if (null == val) {
            return null;
        }
        BigDecimal bd = type.toBigDecimal(val);
        return ValuePool.getInt(bd.doubleValue() < 0.0 ? -1 : (bd.doubleValue() > 0.0 ? 1 : 0));
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

