/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class RTrimFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();

    public RTrimFunction() {
        super("RTRIM");
    }

    public ConcreteFunction makeNewInstance() {
        return new RTrimFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        int len;
        int i;
        Object trimSourceObj;
        Object trimCharObj;
        String trimCharStr;
        char trimChar = ' ';
        if (this.getArgumentCount() == 2 && (trimCharStr = (String)RETURN_TYPE.convert(trimCharObj = this.getArgument(1).evaluate(row))) != null && trimCharStr.length() > 0) {
            trimChar = trimCharStr.charAt(0);
        }
        if ((trimSourceObj = this.getArgument(0).evaluate(row)) == null || "".equals(trimSourceObj)) {
            return trimSourceObj;
        }
        String trimSourceStr = (String)RETURN_TYPE.convert(trimSourceObj);
        int trimSourceLen = trimSourceStr.length();
        for (i = len = trimSourceLen - 1; i > 0 && trimSourceStr.charAt(i) == trimChar; --i) {
        }
        trimSourceStr = i == len ? trimSourceStr : trimSourceStr.substring(0, i + 1);
        return trimSourceStr;
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 1 && this.getArgumentCount() < 3;
    }
}

