/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;

public class InFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType BOOLEAN_TYPE = new BooleanType();

    public InFunction() {
        super("IN");
    }

    public ConcreteFunction makeNewInstance() {
        return new InFunction();
    }

    public DataType getDataType() {
        return BOOLEAN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object lval = this.getArgument(0).evaluate(row);
        if (lval == null) {
            return Boolean.FALSE;
        }
        DataType ltype = this.getArgument(0).getDataType();
        int I = this.getArgumentCount();
        for (int i = 1; i < I; ++i) {
            Selectable arg = this.getArgument(i);
            if (arg instanceof SubSelectCommand) {
                return this.handleSubSelect((SubSelectCommand)arg, row, lval, ltype);
            }
            try {
                Object rval = ltype.convert(arg.evaluate(row));
                if (null == rval || ltype.compare(lval, rval) != 0) continue;
                return Boolean.TRUE;
            }
            catch (AxionException e) {
                // empty catch block
            }
        }
        return Boolean.FALSE;
    }

    private Boolean handleSubSelect(SubSelectCommand cmd, RowDecorator row, Object lval, DataType ltype) throws AxionException {
        RowIterator iter = (RowIterator)cmd.evaluate(row);
        while (iter.hasNext()) {
            Row rrow = iter.next();
            int J = rrow.size();
            for (int j = 0; j < J; ++j) {
                Object rval = rrow.get(j);
                try {
                    rval = ltype.convert(rval);
                    if (null == rval || ltype.compare(lval, rval) != 0) continue;
                    return Boolean.TRUE;
                }
                catch (AxionException e) {
                    // empty catch block
                }
            }
        }
        return Boolean.FALSE;
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 1;
    }
}

