/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;
import org.axiondb.types.TimestampType;
import org.axiondb.util.DateTimeUtils;

public class DateAddFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new TimestampType();
    private static final DataType STRING_TYPE = new StringType();
    private static final DataType INT_TYPE = new IntegerType();

    public DateAddFunction() {
        super("DATEADD");
    }

    public ConcreteFunction makeNewInstance() {
        return new DateAddFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Timestamp timestamp = null;
        int interval = -1;
        int intervalType = DateTimeUtils.labelToCode((String)STRING_TYPE.convert(this.getArgument(0).evaluate(row)));
        Object val = this.getArgument(1).evaluate(row);
        if (null == val) {
            return null;
        }
        interval = (Integer)INT_TYPE.convert(val);
        Object val2 = this.getArgument(2).evaluate(row);
        if (val2 == null) {
            return null;
        }
        timestamp = (Timestamp)RETURN_TYPE.convert(val2);
        return this.calculateDateAdd(intervalType, interval, timestamp);
    }

    private Timestamp calculateDateAdd(int intervalType, int interval, Timestamp t) {
        Calendar c = Calendar.getInstance(TimestampType.getTimeZone());
        c.setTimeInMillis(t.getTime());
        switch (intervalType) {
            default: {
                return this.addMillisecondsTo(c, interval);
            }
            case 2: {
                return this.addSecondsTo(c, interval);
            }
            case 4: {
                return this.addMinutesTo(c, interval);
            }
            case 8: {
                return this.addHoursTo(c, interval);
            }
            case 16: {
                return this.addDaysTo(c, interval);
            }
            case 32: {
                return this.addWeeksTo(c, interval);
            }
            case 64: {
                return this.addMonthsTo(c, interval);
            }
            case 128: {
                return this.addQuartersTo(c, interval);
            }
            case 256: 
        }
        return this.addYearsTo(c, interval);
    }

    private Timestamp addMillisecondsTo(Calendar c, int milliseconds) {
        c.add(14, milliseconds);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addSecondsTo(Calendar c, int seconds) {
        c.add(13, seconds);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addMinutesTo(Calendar c, int minutes) {
        c.add(12, minutes);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addHoursTo(Calendar c, int hours) {
        c.add(10, hours);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addDaysTo(Calendar c, int days) {
        c.add(6, days);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addWeeksTo(Calendar c, int weeks) {
        c.add(3, weeks);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addMonthsTo(Calendar c, int months) {
        c.add(2, months);
        return new Timestamp(c.getTimeInMillis());
    }

    private Timestamp addQuartersTo(Calendar c, int quarters) {
        return this.addMonthsTo(c, quarters * 3);
    }

    private Timestamp addYearsTo(Calendar c, int years) {
        c.add(1, years);
        return new Timestamp(c.getTimeInMillis());
    }

    public boolean isValid() {
        return this.getArgumentCount() == 3;
    }
}

