/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;
import org.axiondb.types.TimestampType;
import org.axiondb.util.DateTimeUtils;

public class CharToDateFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new TimestampType();
    private static final DataType STRING_TYPE = new StringType();

    public CharToDateFunction() {
        super("CHARTODATE");
    }

    public ConcreteFunction makeNewInstance() {
        return new CharToDateFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        String dateStr = null;
        String formatStr = null;
        Object arg2 = this.getArgument(1).evaluate(row);
        if (null == arg2) {
            throw new AxionException("CharToDate cannot accept a null format string.");
        }
        formatStr = (String)STRING_TYPE.convert(arg2);
        Object arg1 = this.getArgument(0).evaluate(row);
        if (null == arg1) {
            return null;
        }
        dateStr = (String)STRING_TYPE.convert(arg1);
        return DateTimeUtils.convertToTimestamp(dateStr, formatStr);
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 2;
    }
}

