/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.visitors;

import java.util.ArrayList;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.BindVariable;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Literal;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.SequenceEvaluator;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.VariableContext;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.functions.CastAsFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.FunctionIdentifier;
import org.axiondb.util.Utils;

public class ResolveSelectableVisitor {
    private Database _db = null;

    public ResolveSelectableVisitor(Database db) {
        this._db = db;
    }

    public Selectable visit(ColumnIdentifier column, List selected, TableIdentifier[] tables) throws AxionException {
        Selectable result = column;
        boolean found = false;
        if (selected != null && !selected.isEmpty()) {
            String aliasName = column.getName();
            int I = selected.size();
            for (int i = 0; i < I; ++i) {
                Selectable sel = (Selectable)selected.get(i);
                if (sel instanceof ColumnIdentifier && (aliasName.equals(sel.getAlias()) || aliasName.equals(sel.getName()))) {
                    ColumnIdentifier colid = (ColumnIdentifier)sel;
                    if (!this.matchTableName(column, colid)) continue;
                    String resolvedAlias = colid.getAlias();
                    String colAlias = column.getAlias();
                    if (resolvedAlias != null && colAlias != null && !resolvedAlias.equals(colAlias)) {
                        column.setTableIdentifier(colid.getTableIdentifier());
                        column.setDataType(colid.getDataType());
                        column.setName(column.getName());
                        break;
                    }
                    column = colid;
                    break;
                }
                if (!aliasName.equals(sel.getAlias())) continue;
                result = sel;
                found = true;
                break;
            }
        }
        if (!found) {
            if (this.isAlreadyResolved(column)) {
                result = column;
            } else if (this.identifiesSequence(column)) {
                Sequence seq = this._db.getSequence(column.getTableName());
                result = new SequenceEvaluator(seq, column.getName());
            } else {
                result = this.resolveTrueColumn(column, tables);
            }
        }
        return this.setVariableContext(result);
    }

    public Selectable visit(FunctionIdentifier fn, List selected, TableIdentifier[] tables) throws AxionException {
        boolean isCastAsFunction;
        ConcreteFunction cfn = this._db.getFunction(fn.getName());
        if (null == cfn) {
            throw new AxionException("No function matching " + fn.getName());
        }
        boolean bl = isCastAsFunction = cfn instanceof CastAsFunction;
        if (isCastAsFunction) {
            ArrayList<Selectable> args = new ArrayList<Selectable>(2);
            Literal literal = (Literal)fn.getArgument(1);
            DataType targetType = this._db.getDataType(literal.getName());
            if (Utils.isPrecisionRequired(targetType.getJdbcType())) {
                targetType = targetType.makeNewInstance();
            }
            if (targetType != null) {
                if (targetType instanceof DataType.NonFixedPrecision) {
                    if (targetType instanceof DataType.ExactNumeric) {
                        Literal scaleVal = (Literal)fn.getArgument(3);
                        int scale = Integer.parseInt(scaleVal.evaluate().toString());
                        ((DataType.ExactNumeric)targetType).setScale(scale);
                    }
                    Literal precisionVal = (Literal)fn.getArgument(2);
                    int precision = Integer.parseInt(precisionVal.evaluate().toString());
                    ((DataType.NonFixedPrecision)targetType).setPrecision(precision);
                }
            } else {
                throw new AxionException("invalid data type: " + literal.getName());
            }
            literal.setDataType(targetType);
            args.add(fn.getArgument(0));
            args.add(fn.getArgument(1));
            String alias = fn.getAlias();
            fn = new FunctionIdentifier(fn.getName(), args);
            fn.setAlias(alias);
        }
        int I = fn.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            cfn.addArgument(this.visit(fn.getArgument(i), selected, tables));
        }
        if (!cfn.isValid()) {
            throw new AxionException("Function " + cfn + " isn't valid.");
        }
        cfn.setAlias(fn.getAlias());
        return this.setVariableContext(cfn);
    }

    public Selectable visit(Selectable selectable, List selected, TableIdentifier[] tables) throws AxionException {
        Selectable result = selectable;
        if (selectable instanceof ColumnIdentifier) {
            result = this.visit((ColumnIdentifier)selectable, selected, tables);
        } else if (selectable instanceof FunctionIdentifier) {
            result = this.visit((FunctionIdentifier)selectable, selected, tables);
        } else if (selectable instanceof ConcreteFunction) {
            result = selectable;
        } else if (selectable instanceof BindVariable) {
            result = selectable;
        } else if (selectable instanceof Literal) {
            result = selectable;
        } else if (selectable instanceof SelectCommand) {
            result = this.visit((SubSelectCommand)selectable, tables);
        } else if (null != selectable) {
            throw new AxionException("Couldn't resolve Selectable " + selectable);
        }
        return this.setVariableContext(result);
    }

    public Selectable visit(SubSelectCommand select, TableIdentifier[] tables) throws AxionException {
        select.setDB(this._db);
        select.setParentTables(tables);
        return this.setVariableContext(select);
    }

    private boolean identifiesSequence(ColumnIdentifier column) {
        return column.getTableName() != null && this._db.getSequence(column.getTableName()) != null;
    }

    private boolean isAlreadyResolved(ColumnIdentifier column) {
        return column.getTableName() != null && column.getTableAlias() != null && column.getDataType() != null;
    }

    private boolean matchTableName(ColumnIdentifier alias, ColumnIdentifier colid) {
        String aliasTableName = alias.getTableName();
        String tableName = colid.getTableName();
        String aliasName = colid.getTableAlias();
        if (aliasTableName == null) {
            return true;
        }
        if (tableName != null && aliasTableName.equals(tableName)) {
            return true;
        }
        return tableName != null && aliasTableName.equals(aliasName);
    }

    private Selectable resolveTrueColumn(ColumnIdentifier column, TableIdentifier[] tables) throws AxionException {
        for (int i = 0; null != tables && i < tables.length; ++i) {
            if (!this._db.hasTable(tables[i])) {
                throw new AxionException(42704);
            }
            if (!this.resolveTrueColumnForTable(column, tables[i])) continue;
            return column;
        }
        throw new AxionException(42703);
    }

    private boolean resolveTrueColumnForTable(ColumnIdentifier column, TableIdentifier tableId) throws AxionException {
        if (null != tableId.getTableAlias() && tableId.getTableAlias().equals(column.getTableName())) {
            column.setTableIdentifier(tableId);
            return this.isStar(column) ? true : this.resolveDataType(column, this._db.getTable(tableId));
        }
        if (tableId.getTableName().equals(column.getTableName())) {
            column.setTableIdentifier(tableId);
            return this.isStar(column) ? true : this.resolveDataType(column, this._db.getTable(tableId));
        }
        if (null == column.getTableName()) {
            if (this.isStar(column)) {
                return true;
            }
            if (this.resolveDataType(column, this._db.getTable(tableId))) {
                column.setTableIdentifier(tableId);
                return true;
            }
        }
        return false;
    }

    private boolean resolveDataType(ColumnIdentifier column, Table table) throws AxionException {
        if (table.hasColumn(column)) {
            Column col = table.getColumn(column.getName());
            column.setDataType(col.getDataType());
            return true;
        }
        return false;
    }

    private boolean isStar(ColumnIdentifier column) {
        return "*".equals(column.getName());
    }

    private Selectable setVariableContext(Selectable sel) {
        if (sel != null && this._db instanceof VariableContext) {
            sel.setVariableContext((VariableContext)((Object)this._db));
        }
        return sel;
    }
}

