/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import com.sun.rowset.WebRowSetImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.sql.rowset.WebRowSet;
import org.apache.commons.collections.primitives.IntCollection;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.TableFactory;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseTable;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.engine.tables.WebRowSetTableLoader;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.FileUtil;
import org.axiondb.types.CharacterType;
import org.axiondb.types.StringType;

public class WebRowSetTable
extends BaseTable
implements ExternalTable {
    protected File _dataFile = null;
    protected File _dbdir = null;
    protected boolean _readOnly = false;
    private File _dir;
    protected String _fileName;
    private int _rowCount = -1;
    private int _currentRow = -1;
    private Properties prop = new Properties();
    public static final String PROP_FILENAME = "FILENAME";
    protected static final String META_FILE_EXT = ".META";
    protected static final String TYPE_FILE_EXT = ".TYPE";
    private WebRowSetTableOrganizationContext context;
    protected static AxionFileSystem FS = new AxionFileSystem();
    protected static final int CURRENT_META_VERSION = 3;
    private static final Set PROPERTY_KEYS = new HashSet(2);
    private WebRowSet xmlRowSet;

    public WebRowSetTable(String name, Database db) throws AxionException {
        super(name);
        this.setType("WEBROWSET TABLE");
        this._dbdir = db.getDBDirectory();
        this._readOnly = db.isReadOnly();
        this.createOrLoadTableFiles(name, db, new WebRowSetTableLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDeletes(IntCollection rowids) throws AxionException {
        WebRowSetTable webRowSetTable = this;
        synchronized (webRowSetTable) {
            try {
                for (int rowid : rowids) {
                    this.xmlRowSet.absolute(rowid);
                    this.xmlRowSet.deleteRow();
                    --this._rowCount;
                }
                this.xmlRowSet.moveToCurrentRow();
                this.writeToFile();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyInserts(RowCollection rows) throws AxionException {
        WebRowSetTable webRowSetTable = this;
        synchronized (webRowSetTable) {
            try {
                int colCount = this.xmlRowSet.getMetaData().getColumnCount();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row row = iter.next();
                    RowInsertedEvent event = new RowInsertedEvent(this, null, row);
                    this.xmlRowSet.moveToInsertRow();
                    for (int i = 1; i <= colCount; ++i) {
                        String colValue = String.valueOf(row.get(i - 1));
                        this.xmlRowSet.updateObject(i, (Object)colValue);
                    }
                    this.xmlRowSet.insertRow();
                    this.xmlRowSet.moveToCurrentRow();
                    ++this._rowCount;
                }
                this.writeToFile();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates(RowCollection rows) throws AxionException {
        WebRowSetTable webRowSetTable = this;
        synchronized (webRowSetTable) {
            try {
                int colCount = this.xmlRowSet.getMetaData().getColumnCount();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row newrow = iter.next();
                    Row oldrow = this.getRow(newrow.getIdentifier());
                    if (oldrow != null) {
                        RowUpdatedEvent event = new RowUpdatedEvent(this, oldrow, newrow);
                    }
                    this.xmlRowSet.absolute(newrow.getIdentifier());
                    for (int i = 1; i <= colCount; ++i) {
                        this.xmlRowSet.updateObject(i, (Object)String.valueOf(newrow.get(i - 1)));
                    }
                    this.xmlRowSet.updateRow();
                    this.xmlRowSet.moveToCurrentRow();
                }
                this.writeToFile();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    public void freeRowId(int id) {
    }

    public void drop() throws AxionException {
        super.drop();
        if (this.xmlRowSet != null) {
            try {
                this.xmlRowSet.close();
            }
            catch (SQLException ex) {
                throw new AxionException("Unable to close the resultset.");
            }
        }
        if (!FileUtil.delete(this.getRootDir())) {
            throw new AxionException("Unable to delete \"" + this.getRootDir() + "\" during drop table " + this.getName());
        }
    }

    private synchronized void writeToFile() throws SQLException, IOException {
        StringWriter writer = new StringWriter();
        this.xmlRowSet.writeXml(writer);
        String str = this.replaceTempRows(writer).toString();
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.getDataFile()));
        bw.write(str, 0, str.length());
        bw.flush();
        bw.close();
        this.xmlRowSet.close();
        this.xmlRowSet = new WebRowSetImpl();
        this.xmlRowSet.readXml(new FileReader(this.getDataFile()));
    }

    public int getNextRowId() {
        return this._currentRow + 1;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void populateIndex(Index index) throws AxionException {
    }

    public Row getRow(int id) throws AxionException {
        Row row;
        try {
            int colCount = this.xmlRowSet.getMetaData().getColumnCount();
            row = new SimpleRow(id, colCount);
            this.xmlRowSet.absolute(id);
            for (int i = 0; i < colCount; ++i) {
                String columnValue = String.valueOf(this.xmlRowSet.getObject(i + 1));
                row = this.trySettingColumn(id, row, i, columnValue);
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
        this._currentRow = id;
        return row;
    }

    protected RowIterator getRowIterator() throws AxionException {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = 0;
            int _currentIndex = 0;
            int _nextId = 1;
            int _nextIndex = 1;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public final int currentIndex() {
                return this._currentIndex;
            }

            public final boolean hasCurrent() {
                return null != this._current;
            }

            public final boolean hasNext() {
                return this.nextIndex() <= WebRowSetTable.this.getRowCount();
            }

            public final boolean hasPrevious() {
                return this.nextIndex() > 1;
            }

            public Row last() throws AxionException {
                if (this.isEmpty()) {
                    throw new IllegalStateException("No rows in table.");
                }
                this._nextIndex = WebRowSetTable.this.getRowCount();
                this._nextId = this._nextIndex++;
                this.previous();
                ++this._nextId;
                return this.current();
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                do {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    this._current = WebRowSetTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public final int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                do {
                    this._currentId = --this._nextId;
                    this._current = WebRowSetTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._current;
            }

            public final int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                WebRowSetTable.this.deleteRow(this._current);
                --this._nextIndex;
                this._currentIndex = 0;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 1;
                this._currentId = 0;
                this._currentIndex = 0;
                this._nextId = 1;
            }

            public final void set(Row row) throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                WebRowSetTable.this.updateRow(this._current, row);
            }

            public final int size() throws AxionException {
                return WebRowSetTable.this.getRowCount();
            }

            public String toString() {
                return "XMLTable(" + WebRowSetTable.this.getName() + ")";
            }

            private Row setCurrentRow() throws AxionException {
                Row row = WebRowSetTable.this.getRowByOffset(this._currentId);
                if (row != null) {
                    this._current = row;
                    return this._current;
                }
                throw new IllegalStateException("No valid row at position " + this._currentIndex);
            }
        };
    }

    public void truncate() throws AxionException {
        try {
            if (this.xmlRowSet == null) {
                this.xmlRowSet = new WebRowSetImpl();
                this.xmlRowSet.readXml(new FileReader(this.getDataFile()));
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    public boolean loadExternalTable(Properties prop) throws AxionException {
        try {
            if (this.context == null) {
                this.context = new WebRowSetTableOrganizationContext();
            }
            this.context.readOrSetDefaultProperties(prop);
            this.context.updateProperties();
            this.initializeTable();
            this.writeMetaFile();
            return true;
        }
        catch (Exception e) {
            try {
                this.drop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AxionException("Failed to create table using supplied properties. ", e);
        }
    }

    public Properties getTableProperties() {
        this.prop.clear();
        this.prop.put("LOADTYPE", "WEBROWSET");
        this.prop.put(PROP_FILENAME, this._dataFile.getAbsolutePath());
        return this.prop;
    }

    public void remount() throws AxionException {
        try {
            this.xmlRowSet = new WebRowSetImpl();
            this.xmlRowSet.readXml(new FileReader(this.getDataFile()));
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrLoadTableFiles(String name, Database db, TableFactory factory) throws AxionException {
        Class<WebRowSetTable> clazz = WebRowSetTable.class;
        synchronized (WebRowSetTable.class) {
            this._dir = new File(db.getDBDirectory(), name.toUpperCase());
            if (!this._dir.exists() && !this._dir.mkdirs()) {
                throw new AxionException("Unable to create directory \"" + this._dir + "\" for Table \"" + name + "\".");
            }
            File typefile = this.getTableFile(TYPE_FILE_EXT);
            if (!typefile.exists()) {
                this.writeNameToFile(typefile, factory);
            }
            this.loadOrMigrateMetaFile(db);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void initializeTable() throws AxionException {
        try {
            if (this.xmlRowSet == null) {
                this.xmlRowSet = new WebRowSetImpl();
            }
            this.xmlRowSet.readXml(new FileReader(this.getDataFile()));
            this._rowCount = this.xmlRowSet.size();
            this._currentRow = 0;
        }
        catch (Exception e) {
            throw new AxionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign) throws AxionException {
        Row row;
        WebRowSetTable webRowSetTable = this;
        synchronized (webRowSetTable) {
            try {
                this.xmlRowSet.absolute(idToAssign);
                int colCount = this.xmlRowSet.getMetaData().getColumnCount();
                row = new SimpleRow(idToAssign, colCount);
                for (int i = 1; i <= colCount; ++i) {
                    String columnValue = String.valueOf(this.xmlRowSet.getObject(i));
                    row = this.trySettingColumn(idToAssign, row, i - 1, columnValue);
                }
            }
            catch (Exception e) {
                if (e instanceof AxionException) {
                    throw (AxionException)e;
                }
                throw new AxionException(e);
            }
        }
        this._currentRow = idToAssign;
        return row;
    }

    protected void loadOrMigrateMetaFile(Database db) throws AxionException {
        this.migrate(db);
    }

    public void migrate(Database db) throws AxionException {
        File metaFile = this.getTableFile(META_FILE_EXT);
        if (!metaFile.exists()) {
            return;
        }
        int version = 3;
        ObjectInputStream in = null;
        try {
            in = FS.openObjectInputSteam(metaFile);
            version = in.readInt();
            if (version < 0 || version > 3) {
                throw new AxionException("Unrecognized version " + version);
            }
            if (version == 0) {
                this.parseV0MetaFile(in);
            } else {
                this.parseV1MetaFile(in, db);
            }
            this.parseTableProperties(in);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeInputStream(in);
        }
        if (version < 3) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                Column col = this.getColumn(i);
                col.getConfiguration().put("name", col.getName().toUpperCase());
            }
        }
        if (version != 3) {
            this.writeMetaFile();
        }
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._fileName = in.readUTF();
            this.context = new WebRowSetTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.initializeTable();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    private void parseV1MetaFile(ObjectInputStream in, Database db) throws AxionException, IOException, ClassNotFoundException {
        this.readColumns(in);
        this.readConstraints(in, db);
    }

    private void parseV0MetaFile(ObjectInputStream in) throws IOException, AxionException {
        int I = in.readInt();
        for (int i = 0; i < I; ++i) {
            String name = in.readUTF();
            String dtypename = in.readUTF();
            DataType type = null;
            try {
                Class<?> clazz = Class.forName(dtypename);
                type = (DataType)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException("Can't load table " + this.getName() + ", data type " + dtypename + " not found.", e);
            }
            this.addColumn(new Column(name, type), false);
        }
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        super.addColumn(col);
        if (metaUpdateNeeded) {
            this.writeMetaFile();
        }
    }

    private File getDataFile() {
        return this._dataFile;
    }

    private Row trySettingColumn(int idToAssign, Row row, int i, String colValue) throws AxionException {
        DataType columnDataType = this.getColumn(i).getDataType();
        if ((colValue = this.evaluateForNull(colValue, columnDataType)) == null) {
            row.set(i, null);
        } else {
            Object val = columnDataType.convert(colValue);
            row.set(i, val);
        }
        return row;
    }

    private String evaluateForNull(String colValue, DataType datatype) {
        if (null == colValue) {
            return null;
        }
        if (datatype instanceof CharacterType) {
            int colWidth = datatype.getPrecision();
            return colWidth <= 0 || colValue.length() == colWidth && colValue.trim().length() == 0 ? null : colValue;
        }
        if (!(datatype instanceof StringType) && colValue.trim().length() == 0) {
            return null;
        }
        return colValue;
    }

    protected boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String getDefaultDataFileExtension() {
        return "xml";
    }

    private void writeMetaFile() throws AxionException {
        ObjectOutputStream out = null;
        File metaFile = this.getTableFile(META_FILE_EXT);
        try {
            out = FS.createObjectOutputSteam(metaFile);
            out.writeInt(3);
            this.writeColumns(out);
            out.flush();
            this.writeConstraints(out);
            out.flush();
            this.writeTableProperties(out);
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected File getTableFile(String extension) {
        return new File(this.getRootDir(), this.getName().toUpperCase() + extension);
    }

    protected File getRootDir() {
        return this._dir;
    }

    protected void writeNameToFile(File file, Object obj) throws AxionException {
        ObjectOutputStream out = null;
        try {
            out = FS.createObjectOutputSteam(file);
            out.writeUTF(obj.getClass().getName());
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._fileName != null) {
                out.writeUTF(this._fileName);
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
    }

    private StringBuffer replaceTempRows(StringWriter writer) {
        StringBuffer buf = new StringBuffer(writer.toString());
        buf = this.deleteMarkedRows(buf);
        buf = this.replaceModifySequence(buf);
        buf = this.replaceInsertSequence(buf);
        return buf;
    }

    private StringBuffer replaceInsertSequence(StringBuffer buf) {
        int end;
        int start;
        boolean shouldSearch = false;
        String startString = "<insertRow>";
        String endString = "</insertRow>";
        int startFrom = 0;
        while (buf.indexOf(startString, startFrom) != -1) {
            shouldSearch = true;
            start = buf.indexOf(startString);
            end = start + startString.length();
            buf.replace(start, end, "<currentRow>");
            startFrom = end;
        }
        if (shouldSearch) {
            startFrom = 0;
            while (buf.indexOf(endString, startFrom) != -1) {
                start = buf.indexOf(endString);
                end = start + endString.length();
                buf.replace(start, end, "</currentRow>");
                startFrom = end;
            }
        }
        return buf;
    }

    private StringBuffer replaceModifySequence(StringBuffer buf) {
        boolean shouldSearch = false;
        String startString = "<currentRow>";
        String endString = "</currentRow>";
        String colString = "<columnValue>";
        String colStringEnd = "</columnValue>";
        String updateString = "<updateValue>";
        String updateStringEnd = "</updateValue>";
        String altUpdateString = "<updateRow>";
        String altUpdateStringEnd = "</updateRow>";
        int startFrom = 0;
        while (buf.indexOf(startString, startFrom) != -1) {
            int check;
            int start = buf.indexOf(startString, startFrom);
            int end = start + startString.length();
            int endValue = buf.indexOf(endString, end);
            int n = check = buf.indexOf(updateString, start) == -1 ? buf.indexOf(altUpdateString, start) : buf.indexOf(updateString, start);
            if (check != -1 && check < endValue) {
                int startFromColValue = end;
                while (buf.indexOf(colString, startFromColValue) != -1 && startFromColValue < endValue) {
                    int colStart = buf.indexOf(colString, startFromColValue);
                    int colEnd = buf.indexOf(colStringEnd, colStart) + colStringEnd.length();
                    buf.delete(colStart, colEnd);
                    startFromColValue = colEnd;
                    endValue = buf.indexOf(endString, end);
                }
                endValue = buf.indexOf(endString, end);
                startFromColValue = end;
                while (buf.indexOf("updateValue", startFromColValue) != -1 || buf.indexOf("updateRow", startFromColValue) != -1) {
                    int startCol = -1;
                    boolean isAlt = false;
                    if (buf.indexOf("updateValue", startFromColValue) != -1) {
                        startCol = buf.indexOf("updateValue", startFromColValue);
                    } else {
                        startCol = buf.indexOf("updateRow", startFromColValue);
                        isAlt = true;
                    }
                    if (startCol >= endValue) break;
                    int endCol = -1;
                    endCol = isAlt ? startCol + "updateRow".length() : startCol + "updateValue".length();
                    buf.replace(startCol, endCol, "columnValue");
                    startFromColValue = startCol;
                    endValue = buf.indexOf(endString, end);
                }
            }
            startFrom = endValue = buf.indexOf(endString, end);
        }
        return buf;
    }

    private StringBuffer deleteMarkedRows(StringBuffer buf) {
        int startFrom = 0;
        while (buf.indexOf("<deleteRow>", startFrom) != -1) {
            int start = buf.indexOf("<deleteRow>");
            int end = buf.indexOf("</deleteRow>") + "</deleteRow>".length();
            buf.delete(start, end);
            startFrom = end;
        }
        return buf;
    }

    static {
        PROPERTY_KEYS.add(PROP_FILENAME);
        PROPERTY_KEYS.add("LOADTYPE");
    }

    private class WebRowSetTableOrganizationContext
    extends BaseTableOrganizationContext {
        private WebRowSetTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            this.assertValidPropertyKeys(props);
            WebRowSetTable.this._fileName = props.getProperty(WebRowSetTable.PROP_FILENAME);
            WebRowSetTable.this._dataFile = new File(WebRowSetTable.this._fileName);
            if (WebRowSetTable.this.isNullString(WebRowSetTable.this._fileName)) {
                WebRowSetTable.this._fileName = WebRowSetTable.this.getName() + "." + WebRowSetTable.this.getDefaultDataFileExtension();
            }
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "WEBROWSET");
            this._props.setProperty(WebRowSetTable.PROP_FILENAME, WebRowSetTable.this._fileName);
        }

        public Set getRequiredPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }
    }
}

