/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTableLoader;
import org.axiondb.Row;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.DelimitedFlatfileTableLoader;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;

public class DelimitedFlatfileTable
extends BaseFlatfileTable {
    protected static final String EMPTY_STRING = "";
    protected static final String COMMA = ",";
    private static final char NL = '\uffff';
    public static final String PROP_FIELDDELIMITER = "FIELDDELIMITER";
    public static final String PROP_QUALIFIER = "QUALIFIER";
    byte[] QUALIFIER_BYTES;
    byte[] EMPTY_STRING_BYTES = "".getBytes();
    byte[] LINESEP_BYTES;
    byte[] FIELDSEP_BYTES;
    private static final Set PROPERTY_KEYS = new HashSet(2);
    private static final Set REQUIRED_KEYS = new HashSet(1);
    static final int LINE_CHAR_ARRAY_SIZE = 80;
    protected String _fieldSep;
    protected String _preferredLineSep;
    protected String[] _lineSeps;
    protected char[] _lineCharArray = new char[80];
    protected String _qualifier;
    protected Pattern _qPattern;
    protected Pattern _qqPattern;

    public DelimitedFlatfileTable(String name, Database db) throws AxionException {
        super(name, db, new DelimitedFlatfileTableLoader());
        this.setType("DELIMITED TEXT TABLE");
    }

    public DelimitedFlatfileTable(String name, Database db, ExternalTableLoader loader) throws AxionException {
        super(name, db, loader);
    }

    protected String getDefaultDataFileExtension() {
        return "csv";
    }

    protected String getQualifier() {
        return this._qualifier;
    }

    protected int getQualifierLength() {
        return this._qualifier.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign, long ptr) throws AxionException {
        BufferedDataInputStream data = this.getInputStream();
        int colCount = this.getColumnCount();
        Row row = new SimpleRow(idToAssign, colCount);
        try {
            BufferedDataInputStream bufferedDataInputStream = data;
            synchronized (bufferedDataInputStream) {
                char[] charArray = this.readLine(data, ptr);
                if (charArray[0] == '\uffff') {
                    throw new AxionException("Empty line detected - invalid.");
                }
                CharTokenizer charTokenizer = new CharTokenizer(charArray, this._fieldSep);
                for (int i = 0; i < colCount && charTokenizer.hasMoreTokens(); ++i) {
                    String columnValue = charTokenizer.nextToken();
                    if (this._trimWhiteSpace && columnValue != null && (columnValue = columnValue.trim()).length() == 0) {
                        columnValue = null;
                    }
                    row = this.trySettingColumn(idToAssign, row, i, columnValue);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof AxionException) {
                throw (AxionException)e;
            }
            throw new AxionException(e);
        }
        return row;
    }

    protected boolean isQuoted() {
        return !this.isNullString(this._qualifier);
    }

    protected boolean isEndOfRecord(int recLength, int nextChar, BufferedDataInputStream data) throws IOException {
        if (this.isEOF(nextChar)) {
            return true;
        }
        boolean foundEOL = false;
        for (int k = 0; k < this._lineSeps.length && !foundEOL; ++k) {
            String lineSep = this._lineSeps[k];
            if (EMPTY_STRING.equals(lineSep) || lineSep.charAt(0) != nextChar) continue;
            foundEOL = true;
            char[] charBuf = lineSep.toCharArray();
            long lastDataFileOffset = data.getPos();
            int I = lineSep.length();
            for (int i = 1; i < I; ++i) {
                if (charBuf[i] == (char)data.read()) continue;
                data.seek(lastDataFileOffset);
                foundEOL = false;
            }
        }
        return foundEOL;
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new DelimitedTableOrganizationContext();
        return super.loadExternalTable(props);
    }

    public Properties getTableProperties() {
        return this.context.getTableProperties();
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._lineSep = in.readUTF();
            this._fieldSep = in.readUTF();
            this._isFirstLineHeader = Boolean.valueOf(in.readUTF());
            this._fileName = in.readUTF();
            in.readUTF();
            this._qualifier = in.readUTF();
            in.readUTF();
            try {
                this._rowCount = in.readInt();
            }
            catch (EOFException ignore) {
                // empty catch block
            }
            this.context = new DelimitedTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.createOrLoadDataFile();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    protected void writeHeader(BufferedDataOutputStream dataFile) throws AxionException {
        if (this._isFirstLineHeader) {
            try {
                CharArrayWriter header = new CharArrayWriter();
                int I = this.getColumnCount();
                for (int i = 0; i < I; ++i) {
                    if (i != 0) {
                        header.write(this._fieldSep);
                    }
                    header.write(this.getColumn(i).getName());
                }
                header.write(this._preferredLineSep);
                dataFile.write(header.toString().getBytes());
                header.close();
            }
            catch (IOException ioex) {
                throw new AxionException("Unable to write header for table: " + this.getName(), ioex);
            }
        }
    }

    protected void writeRow(BufferedDataOutputStream buffer, Row row) throws AxionException {
        Object colValue = null;
        DataType type = null;
        this.QUALIFIER_BYTES = this._qualifier.getBytes();
        this.LINESEP_BYTES = this._preferredLineSep.getBytes();
        this.FIELDSEP_BYTES = this._fieldSep.getBytes();
        try {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                byte[] qualifier;
                colValue = row.get(i);
                type = this.getColumn(i).getDataType();
                if (i != 0) {
                    buffer.write(this.FIELDSEP_BYTES);
                }
                byte[] byArray = qualifier = this.isEscapeRequired(type) ? this.QUALIFIER_BYTES : this.EMPTY_STRING_BYTES;
                if (colValue != null) {
                    buffer.write(qualifier);
                    String val = type.toString(colValue);
                    if (this.isQuoted() && val.indexOf(this._qualifier) != -1) {
                        val = this._qPattern.matcher(val).replaceAll(this._qualifier + this._qualifier);
                    }
                    buffer.write(val.getBytes());
                    buffer.write(qualifier);
                    continue;
                }
                buffer.write(this.EMPTY_STRING_BYTES);
            }
            buffer.write(this.LINESEP_BYTES);
        }
        catch (IOException e) {
            throw new AxionException("Error writing row: " + row, e);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._lineSep != null && this._fieldSep != null && this._fileName != null) {
                out.writeUTF(this._lineSep);
                out.writeUTF(this._fieldSep);
                out.writeUTF(Boolean.toString(this._isFirstLineHeader));
                out.writeUTF(this._fileName);
                out.writeUTF(this._lineSep);
                out.writeUTF(this._qualifier);
                out.writeUTF("true");
                out.writeInt(this._rowsToSkip);
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
    }

    private boolean isEscapeRequired(DataType type) {
        switch (type.getJdbcType()) {
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private char[] readLine(BufferedDataInputStream data, long fileOffset) throws AxionException {
        Arrays.fill(this._lineCharArray, ' ');
        int recLength = 0;
        try {
            data.seek(fileOffset);
            while (true) {
                int nextChar;
                if (this.isEndOfRecord(recLength, nextChar = data.read(), data)) break;
                if (recLength + 2 > this._lineCharArray.length) {
                    char[] newlineCharArray = new char[recLength + 80];
                    System.arraycopy(this._lineCharArray, 0, newlineCharArray, 0, this._lineCharArray.length);
                    this._lineCharArray = newlineCharArray;
                }
                this._lineCharArray[recLength++] = (char)nextChar;
            }
            this._lineCharArray[recLength] = 65535;
            return this._lineCharArray;
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse data file: ", e);
        }
    }

    protected boolean isNewLine(int nextChar) {
        return nextChar == 65535;
    }

    static {
        PROPERTY_KEYS.add(PROP_FIELDDELIMITER);
        PROPERTY_KEYS.add(PROP_QUALIFIER);
    }

    class CharTokenizer {
        char[] _charArray;
        private int _currentPosition;
        private String _delimiters;
        private int _maxPosition;

        public CharTokenizer(char[] thecharArray, String theDelim) {
            this._delimiters = theDelim;
            this._charArray = thecharArray;
            this._maxPosition = this._charArray.length;
            this._currentPosition = 0;
        }

        public boolean hasMoreTokens() {
            return this._currentPosition < this._maxPosition;
        }

        public String nextToken() {
            int start;
            int end = start = this._currentPosition;
            int pos = this._currentPosition;
            boolean inQuotedString = false;
            boolean endQuotedString = false;
            boolean treatAsUnquoted = false;
            boolean wasEscaped = false;
            while (pos < this._maxPosition) {
                if (DelimitedFlatfileTable.this.isNewLine(this._charArray[pos])) {
                    if (DelimitedFlatfileTable.this.isQuoted() && !endQuotedString) {
                        this._maxPosition = pos;
                        this._currentPosition = pos;
                        end = pos;
                        break;
                    }
                    this._currentPosition = this._maxPosition;
                }
                if (DelimitedFlatfileTable.this.isQuoted() && this.isQualifier(pos)) {
                    if (!inQuotedString) {
                        start = pos += DelimitedFlatfileTable.this.getQualifierLength();
                        inQuotedString = true;
                        continue;
                    }
                    if (this.isQualifier(pos + DelimitedFlatfileTable.this.getQualifierLength())) {
                        pos += DelimitedFlatfileTable.this.getQualifierLength() * 2;
                        wasEscaped = true;
                        continue;
                    }
                    end = pos;
                    pos += DelimitedFlatfileTable.this.getQualifierLength();
                    inQuotedString = false;
                    endQuotedString = true;
                    continue;
                }
                if (DelimitedFlatfileTable.this.isQuoted() && endQuotedString && this._delimiters.charAt(0) != this._charArray[pos] && !DelimitedFlatfileTable.this.isNewLine(this._charArray[pos])) {
                    ++pos;
                    continue;
                }
                if (DelimitedFlatfileTable.this.isQuoted() && endQuotedString) {
                    if (this.isDelimiter(pos)) {
                        pos += this._delimiters.length();
                        break;
                    }
                    if (DelimitedFlatfileTable.this.isNewLine(this._charArray[pos])) break;
                }
                if (DelimitedFlatfileTable.this.isQuoted() && !inQuotedString) {
                    treatAsUnquoted = true;
                }
                if ((!DelimitedFlatfileTable.this.isQuoted() || treatAsUnquoted) && pos < this._maxPosition) {
                    if (this.isDelimiter(pos)) {
                        end = pos;
                        pos += this._delimiters.length();
                        break;
                    }
                    if (DelimitedFlatfileTable.this.isNewLine(this._charArray[pos])) {
                        end = pos;
                        break;
                    }
                }
                ++pos;
            }
            this._currentPosition = pos;
            if (pos == this._maxPosition) {
                end = this._maxPosition;
            }
            if (start != end) {
                String token = new String(this._charArray, start, end - start);
                if (wasEscaped) {
                    return DelimitedFlatfileTable.this._qqPattern.matcher(token).replaceAll(DelimitedFlatfileTable.this._qualifier);
                }
                return token;
            }
            if (endQuotedString) {
                return DelimitedFlatfileTable.EMPTY_STRING;
            }
            return null;
        }

        private boolean isDelimiter(int position) {
            boolean delimiterFound = true;
            int J = this._delimiters.length();
            for (int j = 0; j < J; ++j) {
                if (this._delimiters.charAt(j) == this._charArray[position++]) continue;
                delimiterFound = false;
                break;
            }
            return delimiterFound;
        }

        private boolean isQualifier(int position) {
            boolean qualifierFound = true;
            int J = DelimitedFlatfileTable.this.getQualifierLength();
            for (int j = 0; j < J; ++j) {
                if (DelimitedFlatfileTable.this.getQualifier().charAt(j) == this._charArray[position++]) continue;
                qualifierFound = false;
                break;
            }
            return qualifierFound;
        }
    }

    private class DelimitedTableOrganizationContext
    extends BaseFlatfileTable.BaseFlatfileTableOrganizationContext {
        private DelimitedTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = super.getPropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            super.readOrSetDefaultProperties(props);
            String rawFieldSep = props.getProperty(DelimitedFlatfileTable.PROP_FIELDDELIMITER);
            if (DelimitedFlatfileTable.this.isNullString(rawFieldSep)) {
                rawFieldSep = DelimitedFlatfileTable.COMMA;
            }
            DelimitedFlatfileTable.this._fieldSep = BaseFlatfileTable.fixEscapeSequence(rawFieldSep);
            String lineSep = System.getProperty("line.separator");
            if (DelimitedFlatfileTable.EMPTY_STRING.equals(DelimitedFlatfileTable.this._lineSep)) {
                DelimitedFlatfileTable.this._lineSep = BaseFlatfileTable.fixEscapeSequence(lineSep);
            }
            StringTokenizer tokenizer = new StringTokenizer(DelimitedFlatfileTable.this._lineSep, " ");
            ArrayList<String> tmpList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                tmpList.add(token);
                if (!token.equals(lineSep)) continue;
                DelimitedFlatfileTable.this._preferredLineSep = token;
            }
            DelimitedFlatfileTable.this._lineSeps = tmpList.toArray(new String[0]);
            if (DelimitedFlatfileTable.this._preferredLineSep == null || DelimitedFlatfileTable.this._preferredLineSep.length() == 0) {
                DelimitedFlatfileTable.this._preferredLineSep = DelimitedFlatfileTable.this._lineSeps[0];
            }
            DelimitedFlatfileTable.this._qualifier = BaseFlatfileTable.fixEscapeSequence(props.getProperty(DelimitedFlatfileTable.PROP_QUALIFIER));
            if (DelimitedFlatfileTable.this.isNullString(DelimitedFlatfileTable.this._qualifier)) {
                DelimitedFlatfileTable.this._qualifier = DelimitedFlatfileTable.EMPTY_STRING;
            } else {
                DelimitedFlatfileTable.this._qPattern = Pattern.compile(DelimitedFlatfileTable.this._qualifier);
                DelimitedFlatfileTable.this._qqPattern = Pattern.compile(DelimitedFlatfileTable.this._qualifier + DelimitedFlatfileTable.this._qualifier);
            }
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "DELIMITED");
            this._props.setProperty(DelimitedFlatfileTable.PROP_FIELDDELIMITER, BaseFlatfileTable.addEscapeSequence(DelimitedFlatfileTable.this._fieldSep));
            this._props.setProperty(DelimitedFlatfileTable.PROP_QUALIFIER, DelimitedFlatfileTable.this._qualifier);
        }

        public Set getRequiredPropertyKeys() {
            Set baseRequiredKeys = this.getBaseRequiredPropertyKeys();
            HashSet keys = new HashSet(baseRequiredKeys.size() + REQUIRED_KEYS.size());
            keys.addAll(baseRequiredKeys);
            keys.addAll(REQUIRED_KEYS);
            return keys;
        }
    }
}

