/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Constraint;
import org.axiondb.ConstraintViolationException;
import org.axiondb.Literal;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.event.BaseTableModificationPublisher;
import org.axiondb.event.RowEvent;
import org.axiondb.functions.AndFunction;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.EqualFunction;

public abstract class AbstractBaseTable
extends BaseTableModificationPublisher
implements Table {
    public RowIterator getMatchingRows(List selectables, List values, boolean readOnly) throws AxionException {
        if (null == selectables || selectables.isEmpty()) {
            return this.getRowIterator(readOnly);
        }
        RowIterator baseIterator = null;
        BaseFunction filter = null;
        int I = selectables.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)selectables.get(i);
            Object val = values.get(i);
            EqualFunction function = new EqualFunction();
            function.addArgument(sel);
            function.addArgument(new Literal(val));
            if (null == baseIterator && (baseIterator = this.getIndexedRows(function, readOnly)) != null) {
                function = null;
            }
            if (function == null) continue;
            if (null == filter) {
                filter = function;
                continue;
            }
            AndFunction fn = new AndFunction();
            fn.addArgument(filter);
            fn.addArgument(function);
            filter = fn;
        }
        if (null == baseIterator) {
            baseIterator = this.getRowIterator(readOnly);
        }
        if (null != filter) {
            return new FilteringRowIterator(baseIterator, this.makeRowDecorator(), filter);
        }
        return baseIterator;
    }

    public void migrate() throws AxionException {
    }

    protected void checkConstraints(RowEvent event, RowDecorator dec) throws AxionException {
        if (this.isDeferAll()) {
            return;
        }
        this.checkConstraints(event, false, dec);
    }

    protected void checkConstraints(RowEvent event, boolean deferred, RowDecorator dec) throws AxionException {
        Iterator iter = this.getConstraints();
        while (iter.hasNext()) {
            Constraint c = (Constraint)iter.next();
            if (c.isDeferred() != deferred || c.evaluate(event, dec)) continue;
            throw new ConstraintViolationException(c);
        }
    }

    protected void checkConstraints(RowIterator oldRows, RowIterator newRows) throws AxionException {
        Iterator iter = this.getConstraints();
        while (iter.hasNext()) {
            Constraint c = (Constraint)iter.next();
            if (c.evaluate(oldRows, newRows, this)) continue;
            throw new ConstraintViolationException(c);
        }
    }

    protected boolean hasDeferredConstraint() {
        if (this.isDeferAll()) {
            return true;
        }
        Iterator iter = this.getConstraints();
        while (iter.hasNext()) {
            Constraint c = (Constraint)iter.next();
            if (!c.isDeferred()) continue;
            return true;
        }
        return false;
    }

    protected boolean isDeferAll() {
        return false;
    }
}

