/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowcollection;

import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntListIterator;

public class IntHashMap {
    private volatile transient Entry[] _entries;
    private transient Entry _head = this.newEntry();
    private transient IntHashMap _oldEntries;
    private transient int _size;
    private transient Entry _tail = this.newEntry();
    private transient Values _values = new Values();
    private transient Keys _keys = new Keys();

    public IntHashMap() {
        this(16);
    }

    public IntHashMap(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new Entry[tableLength];
        this._head._next = this._tail;
        this._tail._previous = this._head;
        Entry previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            Entry newEntry = this.newEntry();
            newEntry._previous = previous;
            previous._next = newEntry;
            previous = newEntry;
        }
    }

    public IntHashMap(IntHashMap map) {
        this(map.size());
        this.putAll(map);
    }

    public void clear() {
        Entry e = this._head;
        Entry end = this._tail;
        while ((e = e._next) != end) {
            e._key = -1;
            e._value = null;
            Entry[] table = e._table;
            table[((Entry)e)._keyHash & table.length - 1] = null;
        }
        this._tail = this._head._next;
        this._size = 0;
        this._oldEntries = null;
    }

    public final boolean containsKey(int key) {
        int keyHash = key;
        Entry entry = this._entries[keyHash & this._entries.length - 1];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && key == entry._key) {
                return true;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? this._oldEntries.containsKey(key) : false;
    }

    public final boolean containsValue(Object value) {
        Entry e = this.headEntry();
        Entry end = this.tailEntry();
        while ((e = e._next) != end) {
            if (!value.equals(e._value)) continue;
            return true;
        }
        return false;
    }

    public EntryIterator entryIterator() {
        return new EntryIterator();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntHashMap) {
            IntHashMap that = (IntHashMap)obj;
            if (this._size == that._size) {
                Entry e = this._head;
                Entry end = this._tail;
                while ((e = e._next) != end) {
                    if (that.containsKey(e._key)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public final Object get(int key) {
        int keyHash = key;
        Entry entry = this._entries[keyHash & this._entries.length - 1];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && key == entry._key) {
                return entry._value;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? this._oldEntries.get(key) : null;
    }

    public final Entry getEntry(int key) {
        int keyHash = key;
        Entry entry = this._entries[keyHash & this._entries.length - 1];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && key == entry._key) {
                return entry;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? this._oldEntries.getEntry(key) : null;
    }

    public int hashCode() {
        int code = 0;
        Entry e = this._head;
        Entry end = this._tail;
        while ((e = e._next) != end) {
            code += e.hashCode();
        }
        return code;
    }

    public final Entry headEntry() {
        return this._head;
    }

    public final boolean isEmpty() {
        return this._head._next == this._tail;
    }

    public IntListIterator keyIterator() {
        return new IntKeyIterator();
    }

    public final Object put(int key, Object value) {
        int keyHash = key;
        Entry entry = this._entries[keyHash & this._entries.length - 1];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && key == entry._key) {
                Object prevValue = entry._value;
                entry._value = value;
                return prevValue;
            }
            entry = entry._beside;
        }
        if (this._oldEntries != null && this._oldEntries.containsKey(key)) {
            return this._oldEntries.put(key, value);
        }
        this.addEntry(keyHash, key, value);
        return null;
    }

    public final void putAll(IntHashMap that) {
        Entry e = that._head;
        Entry end = that._tail;
        while ((e = e._next) != end) {
            this.put(e._key, e._value);
        }
    }

    public final Object remove(int key) {
        int keyHash = key;
        Entry entry = this._entries[keyHash & this._entries.length - 1];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && key == entry._key) {
                Object prevValue = entry._value;
                this.removeEntry(entry);
                return prevValue;
            }
            entry = entry._beside;
        }
        if (this._oldEntries != null && this._oldEntries.containsKey(key)) {
            --this._size;
            this._oldEntries._tail = this._tail;
            return this._oldEntries.remove(key);
        }
        return null;
    }

    public void removeEntry(Entry entry) {
        --this._size;
        entry._key = -1;
        entry._value = null;
        entry.detach();
        Entry next = this._tail._next;
        entry._previous = this._tail;
        entry._next = next;
        this._tail._next = entry;
        if (next != null) {
            next._previous = entry;
        }
    }

    public final ValueIterator valueIterator() {
        return new ValueIterator();
    }

    public final int size() {
        return this._size;
    }

    public final Entry tailEntry() {
        return this._tail;
    }

    public String toString() {
        return this._entries.toString();
    }

    public final Values values() {
        return this._values;
    }

    public IntCollection keys() {
        return this._keys;
    }

    protected Entry newEntry() {
        return new Entry();
    }

    protected void addEntry(int hash, int key, Object value) {
        Entry newTail;
        if (this._size++ > this._entries.length) {
            this.increaseEntryTable();
        }
        if ((newTail = this._tail._next) == null) {
            newTail = this._tail._next = this.newEntry();
            newTail._previous = this._tail;
        }
        this._tail._key = key;
        this._tail._value = value;
        this._tail._keyHash = hash;
        Entry.access$402(this._tail, this._entries);
        int index = hash & this._entries.length - 1;
        Entry beside = this._entries[index];
        this._tail._beside = beside;
        this._entries[index] = this._tail;
        this._tail = newTail;
    }

    private void increaseEntryTable() {
        int minLength = this._entries.length << 1;
        IntHashMap oldEntries = new IntHashMap(64);
        oldEntries = minLength <= 64 ? new IntHashMap(64) : (minLength <= 256 ? new IntHashMap(256) : (minLength <= 1024 ? new IntHashMap(1024) : (minLength <= 16384 ? new IntHashMap(16384) : (minLength <= 262144 ? new IntHashMap(262144) : (minLength <= 0x400000 ? new IntHashMap(0x400000) : (minLength <= 0x4000000 ? new IntHashMap(0x4000000) : new IntHashMap(0x40000000)))))));
        Entry[] newEntries = oldEntries._entries;
        oldEntries._entries = this._entries;
        this._entries = newEntries;
        oldEntries._oldEntries = this._oldEntries;
        oldEntries._head = null;
        oldEntries._tail = null;
        oldEntries._size = -1;
        this._oldEntries = oldEntries;
    }

    protected class Values {
        protected Values() {
        }

        public boolean add(Object row) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            IntHashMap.this.clear();
        }

        public ValueIterator iterator() {
            return IntHashMap.this.valueIterator();
        }

        public int size() {
            return IntHashMap.this._size;
        }

        public boolean contains(Object row) {
            return IntHashMap.this.containsValue(row);
        }

        public boolean isEmpty() {
            return IntHashMap.this.isEmpty();
        }

        public boolean remove(Object row) {
            Entry r = IntHashMap.this.headEntry();
            Entry end = IntHashMap.this.tailEntry();
            while ((r = r._next) != end) {
                if (!row.equals(r._value)) continue;
                IntHashMap.this.removeEntry(r);
                return true;
            }
            return false;
        }
    }

    private class Keys
    implements IntCollection {
        private Keys() {
        }

        public boolean add(int id) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            IntHashMap.this.clear();
        }

        public boolean contains(int id) {
            return IntHashMap.this.containsKey(id);
        }

        public boolean isEmpty() {
            return IntHashMap.this.isEmpty();
        }

        public IntIterator iterator() {
            return IntHashMap.this.keyIterator();
        }

        public boolean remove(int id) {
            return IntHashMap.this.remove(id) != null;
        }

        public int size() {
            return IntHashMap.this.size();
        }

        public boolean addAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeElement(int element) {
            return IntHashMap.this.remove(element) != null;
        }

        public boolean retainAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public int[] toArray() {
            throw new UnsupportedOperationException();
        }

        public int[] toArray(int[] a) {
            throw new UnsupportedOperationException();
        }
    }

    public class ValueIterator
    extends EntryIterator {
        public void add(Object row) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public Object current() throws NoSuchElementException {
            return this.currentEntry().getValue();
        }

        public Object first() throws NoSuchElementException {
            return this.firstEntry().getValue();
        }

        public Object last() throws NoSuchElementException {
            return this.lastEntry().getValue();
        }

        public Object next() throws NoSuchElementException {
            return this.nextEntry().getValue();
        }

        public Object peekNext() throws NoSuchElementException {
            return this.peekNextEntry().getValue();
        }

        public Object peekPrevious() throws NoSuchElementException {
            return this.peekPreviousEntry().getValue();
        }

        public Object previous() throws NoSuchElementException {
            return this.previousEntry().getValue();
        }

        public void set(Object row) throws UnsupportedOperationException {
            if (!this.hasCurrent()) {
                throw new IllegalStateException();
            }
            this.currentEntry().setValue(row);
        }

        public int next(int count) {
            for (int i = 0; i < count; ++i) {
                this.next();
            }
            return this.currentEntry().getKey();
        }

        public int previous(int count) {
            for (int i = 0; i < count; ++i) {
                this.previous();
            }
            return this.currentEntry().getKey();
        }
    }

    private class IntKeyIterator
    extends EntryIterator
    implements IntListIterator {
        private IntKeyIterator() {
        }

        public int next() {
            return this.nextEntry().getKey();
        }

        public void add(int element) {
            throw new UnsupportedOperationException();
        }

        public int previous() {
            return this.previousEntry().getKey();
        }

        public void set(int element) {
            throw new UnsupportedOperationException();
        }
    }

    public class EntryIterator {
        private int _currentIndex;
        private Entry _currentNode;
        private int _nextIndex;
        private Entry _nextNode;

        public EntryIterator() {
            this._nextNode = IntHashMap.this._head._next;
            this._currentNode = null;
            this._nextIndex = 0;
            this._currentIndex = -1;
        }

        public void addEntry(int hash, int key, Object value) {
            IntHashMap.this.addEntry(hash, key, value);
            this._currentNode = null;
            ++this._nextIndex;
            this._currentIndex = -1;
        }

        public Entry currentEntry() {
            if (!this.hasCurrent()) {
                throw new NoSuchElementException();
            }
            return this._currentNode;
        }

        public int currentIndex() {
            return this._currentIndex;
        }

        public Entry firstEntry() {
            this.reset();
            return this.peekNextEntry();
        }

        public boolean hasCurrent() {
            return this._currentNode != null;
        }

        public boolean hasNext() {
            return this._nextIndex < IntHashMap.this._size;
        }

        public boolean hasPrevious() {
            return this._nextIndex > 0;
        }

        public boolean isEmpty() {
            return IntHashMap.this.isEmpty();
        }

        public Entry lastEntry() {
            if (!this.hasNext()) {
                this.previousEntry();
            }
            Entry entry = null;
            while (this.hasNext()) {
                entry = this.nextEntry();
            }
            return entry;
        }

        public Entry nextEntry() {
            if (this._nextIndex == IntHashMap.this._size) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode;
        }

        public int nextIndex() {
            return this._nextIndex;
        }

        public Entry peekNextEntry() {
            this.nextEntry();
            return this.previousEntry();
        }

        public Entry peekPreviousEntry() {
            this.previousEntry();
            return this.nextEntry();
        }

        public Entry previousEntry() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentIndex = this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode;
        }

        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void remove() {
            if (this._currentNode != null) {
                if (this._nextNode == this._currentNode) {
                    this._nextNode = this._nextNode._next;
                } else {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            IntHashMap.this.removeEntry(this._currentNode);
            this._currentNode = null;
            this._currentIndex = -1;
        }

        public void reset() {
            this._nextNode = IntHashMap.this._head._next;
            this._currentNode = null;
            this._nextIndex = 0;
            this._currentIndex = -1;
        }

        public void setEntry(Entry o) {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode = o;
        }

        public int size() {
            return IntHashMap.this._size;
        }
    }

    public static class Entry {
        private Entry _beside;
        private int _key;
        private int _keyHash;
        private Entry _next;
        private Entry _previous;
        private Entry[] _table;
        private Object _value;

        protected Entry() {
        }

        public boolean equals(Object that) {
            if (that instanceof Entry) {
                Entry entry = (Entry)that;
                return this._key == this.getKey() && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        public final int getKey() {
            return this._key;
        }

        public Entry getNextEntry() {
            return this._next;
        }

        public Entry getPreviousEntry() {
            return this._previous;
        }

        public final Object getValue() {
            return this._value;
        }

        public int hashCode() {
            return this._key ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public final Object setValue(Object value) {
            Object old = this._value;
            this._value = value;
            return old;
        }

        private void detach() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            int index = this._keyHash & this._table.length - 1;
            Entry beside = this._beside;
            Entry previous = this._table[index];
            if (previous == this) {
                this._table[index] = beside;
            } else {
                while (previous._beside != this) {
                    previous = previous._beside;
                }
                previous._beside = beside;
            }
        }

        static /* synthetic */ Entry[] access$402(Entry x0, Entry[] x1) {
            x0._table = x1;
            return x1;
        }
    }
}

