/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.DatabaseTypeEvent;
import org.axiondb.util.ValuePool;

public class AxionTypesMetaTableUpdater
extends BaseDatabaseModificationListener
implements DatabaseModificationListener {
    private static Logger _log = Logger.getLogger(AxionTypesMetaTableUpdater.class.getName());
    private Database _db = null;

    public AxionTypesMetaTableUpdater(Database db) {
        this._db = db;
    }

    public void typeAdded(DatabaseTypeEvent e) {
        Row row = this.createRowForAddedType(e.getName(), e.getDataType());
        try {
            this._db.getTable("AXION_TYPES").addRow(row);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to mention type in system tables", ex);
        }
    }

    private Row createRowForAddedType(String name, DataType type) {
        Boolean isFixedPrecisionScale = type instanceof DataType.ExactNumeric;
        SimpleRow row = new SimpleRow(18);
        row.set(0, name);
        row.set(1, new Short((short)type.getJdbcType()));
        row.set(2, null);
        row.set(3, type.getLiteralPrefix());
        row.set(4, type.getLiteralSuffix());
        row.set(5, null);
        row.set(6, ValuePool.getInt(type.getNullableCode()));
        row.set(7, ValuePool.getBoolean(type.isCaseSensitive()));
        row.set(8, ValuePool.getInt(type.getSearchableCode()));
        row.set(9, ValuePool.getBoolean(type.isUnsigned()));
        row.set(10, isFixedPrecisionScale);
        row.set(11, Boolean.FALSE);
        row.set(12, null);
        row.set(13, null);
        row.set(14, null);
        row.set(15, null);
        row.set(16, null);
        row.set(17, ValuePool.getInt(type.getPrecisionRadix()));
        return row;
    }
}

