/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.DatabaseLink;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.Selectable;
import org.axiondb.engine.commands.DeleteCommand;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.DatabaseLinkEvent;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.functions.FunctionIdentifier;

public class AxionDBLinksMetaTableUpdater
extends BaseDatabaseModificationListener
implements DatabaseModificationListener {
    private static Logger _log = Logger.getLogger(AxionDBLinksMetaTableUpdater.class.getName());
    private Database _db = null;

    public AxionDBLinksMetaTableUpdater(Database db) {
        this._db = db;
    }

    protected Row createRowForAddedServer(DatabaseLink server) {
        String name = server.getName();
        String url = server.getJdbcUrl();
        String userName = server.getUserName();
        SimpleRow row = new SimpleRow(3);
        row.set(0, name);
        row.set(1, url);
        row.set(2, userName);
        return row;
    }

    public void serverAdded(DatabaseLinkEvent e) {
        Row row = this.createRowForAddedServer(e.getExternalDatabaseLink());
        try {
            this._db.getTable("AXION_DB_LINKS").addRow(row);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to mention database link in system tables", ex);
        }
    }

    public void serverDropped(DatabaseLinkEvent e) {
        FunctionIdentifier fn = new FunctionIdentifier("=");
        fn.addArgument(new ColumnIdentifier("LINK_NAME"));
        fn.addArgument(new Literal(e.getExternalDatabaseLink().getName()));
        DeleteCommand cmd = new DeleteCommand("AXION_DB_LINKS", (Selectable)fn);
        try {
            cmd.execute(this._db);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to remove mention of database link in system tables", ex);
        }
    }
}

