/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import java.io.IOException;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntListIterator;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Function;
import org.axiondb.IndexLoader;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Table;
import org.axiondb.engine.IntBTreeIndexLoader;
import org.axiondb.engine.indexes.BaseBTreeIndex;
import org.axiondb.engine.rowiterators.EmptyRowIterator;
import org.axiondb.engine.rowiterators.LazyRowRowIterator;
import org.axiondb.event.RowEvent;
import org.axiondb.event.TableModificationListener;
import org.axiondb.functions.ComparisonFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.functions.GreaterThanFunction;
import org.axiondb.functions.GreaterThanOrEqualFunction;
import org.axiondb.functions.IsNotNullFunction;
import org.axiondb.functions.IsNullFunction;
import org.axiondb.functions.LessThanFunction;
import org.axiondb.functions.LessThanOrEqualFunction;
import org.axiondb.util.IntBTree;
import org.axiondb.util.IntListIteratorChain;
import org.axiondb.util.NullObject;

public class IntBTreeIndex
extends BaseBTreeIndex
implements TableModificationListener {
    private static final IndexLoader LOADER = new IntBTreeIndexLoader();
    private File _dataDirectory;
    private IntBTree _tree = null;

    public IntBTreeIndex(String name, Column column, boolean unique) throws AxionException {
        this(name, column, unique, null);
    }

    public IntBTreeIndex(String name, Column column, boolean unique, File dataDirectory) throws AxionException {
        super(name, column, unique);
        try {
            this._dataDirectory = dataDirectory;
            this._tree = new IntBTree(this._dataDirectory, this.getName(), 1000);
        }
        catch (Exception e) {
            String msg = "Unable to create index file for " + this.getName() + " due to IOException";
            throw new AxionException(msg, e);
        }
    }

    public void changeRowId(Table table, Row row, int oldId, int newId) throws AxionException {
        try {
            int colnum = table.getColumnIndex(this.getIndexedColumn().getName());
            Integer key = (Integer)row.get(colnum);
            this._tree.replaceId(key, oldId, newId);
        }
        catch (Exception e) {
            String msg = "Unable to change row id in index " + this.getName() + " due to IOException";
            throw new AxionException(msg, e);
        }
    }

    public IntBTree getBTree() {
        return this._tree;
    }

    public IndexLoader getIndexLoader() {
        return LOADER;
    }

    public final RowIterator getInorderRowIterator(RowSource source) throws AxionException {
        IntListIteratorChain resultIds = null;
        try {
            resultIds = this._tree.inorderIterator();
        }
        catch (IOException e) {
            String msg = "Unable to retrieve values from index" + this.getName();
            throw new AxionException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to retrieve values from index" + this.getName();
            throw new AxionException(msg, e);
        }
        return new LazyRowRowIterator(source, resultIds, this._tree.size());
    }

    public RowIterator getRowIterator(RowSource source, Function function, Object value) throws AxionException {
        IntListIterator resultIds;
        block14: {
            resultIds = null;
            try {
                if (function instanceof ComparisonFunction) {
                    int iSuccessor;
                    DataType type = this.getIndexedColumn().getDataType();
                    Object convertedValue = type.convert(value);
                    if (null == convertedValue) {
                        return EmptyRowIterator.INSTANCE;
                    }
                    int iVal = type.toInt(convertedValue);
                    if (function instanceof EqualFunction) {
                        if (!this.isUnique()) {
                            resultIds = this._tree.getAll(iVal);
                            break block14;
                        }
                        Integer result = this._tree.get(iVal);
                        if (result == null) {
                            return EmptyRowIterator.INSTANCE;
                        }
                        ArrayIntList ids = new ArrayIntList(1);
                        ids.add(result.intValue());
                        return new LazyRowRowIterator(source, ids.listIterator(), 1);
                    }
                    if (function instanceof LessThanFunction) {
                        resultIds = this._tree.getAllTo(iVal);
                        break block14;
                    }
                    if (function instanceof LessThanOrEqualFunction) {
                        iSuccessor = this.getSuccessor(type, convertedValue);
                        resultIds = this._tree.getAllTo(iSuccessor);
                        break block14;
                    }
                    if (function instanceof GreaterThanFunction) {
                        iSuccessor = this.getSuccessor(type, convertedValue);
                        resultIds = this._tree.valueIteratorGreaterThanOrEqualTo(iSuccessor);
                        break block14;
                    }
                    if (function instanceof GreaterThanOrEqualFunction) {
                        resultIds = this._tree.valueIteratorGreaterThanOrEqualTo(iVal);
                        break block14;
                    }
                    throw new AxionException("Unsupported function " + function);
                }
                if (function instanceof IsNotNullFunction) {
                    resultIds = this._tree.getAllExcludingNull();
                    break block14;
                }
                if (function instanceof IsNullFunction) {
                    resultIds = this._tree.getAll(NullObject.INSTANCE.intValue());
                    break block14;
                }
                throw new AxionException("Unsupported function " + function);
            }
            catch (Exception e) {
                String msg = "Unable to retrieve values from index " + this.getName() + " due to IOException";
                throw new AxionException(msg, e);
            }
        }
        ArrayIntList ids = new ArrayIntList();
        while (resultIds.hasNext()) {
            ids.add(resultIds.next());
        }
        return new LazyRowRowIterator(source, ids.listIterator(), ids.size());
    }

    public void rowDeleted(RowEvent event) throws AxionException {
        String colName = this.getIndexedColumn().getName();
        int colIndex = event.getTable().getColumnIndex(colName);
        Integer key = (Integer)event.getOldRow().get(colIndex);
        int rowid = event.getOldRow().getIdentifier();
        int intKey = key == null ? NullObject.INSTANCE.intValue() : key.intValue();
        try {
            this._tree.delete(intKey, rowid);
        }
        catch (Exception e) {
            String msg = "Unable to delete from index " + this.getName() + " due to " + e.getMessage();
            throw new AxionException(msg, e);
        }
    }

    public void rowInserted(RowEvent event) throws AxionException {
        String colName = this.getIndexedColumn().getName();
        int colIndex = event.getTable().getColumnIndex(colName);
        Integer value = (Integer)event.getNewRow().get(colIndex);
        int intValue = value == null ? NullObject.INSTANCE.intValue() : value.intValue();
        try {
            this._tree.insert(intValue, event.getNewRow().getIdentifier());
        }
        catch (Exception e) {
            String msg = "Unable to insert into index " + this.getName() + " due to IOException";
            throw new AxionException(msg, e);
        }
    }

    public void rowUpdated(RowEvent event) throws AxionException {
        this.rowDeleted(event);
        this.rowInserted(event);
    }

    public void truncate() throws AxionException {
        this._tree.truncate();
    }

    private int getSuccessor(DataType type, Object convertedValue) throws AxionException {
        return type.toInt(type.successor(convertedValue));
    }
}

