/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.Iterator;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Table;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.tables.TableView;
import org.axiondb.jdbc.AxionResultSet;

public class TruncateCommand
extends BaseAxionCommand {
    private String _tableName;

    public int executeUpdate(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        Table t = db.getTable(this._tableName);
        if (t != null && !t.getType().equals(TableView.VIEW) && !t.getType().equals("SYSTEM TABLE")) {
            this.checkConstraint(db, t);
            int rowcount = t.getRowCount();
            t.truncate();
            this.setEffectedRowCount(rowcount);
            return rowcount;
        }
        throw new AxionException("Table " + this._tableName + " not found.");
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use executeUpdate.");
    }

    public boolean execute(Database db) throws AxionException {
        this.executeUpdate(db);
        return false;
    }

    public void setObjectName(String theTableName) {
        this._tableName = theTableName;
    }

    protected void checkConstraint(Database db, Table table) throws AxionException {
        Iterator iter = table.getConstraints();
        while (iter.hasNext()) {
            Table childTable;
            ForeignKeyConstraint fk;
            Object constraint = iter.next();
            if (!(constraint instanceof ForeignKeyConstraint) || (fk = (ForeignKeyConstraint)constraint).getParentTableName().equals(fk.getChildTableName()) || !table.getName().equals(fk.getParentTableName()) || (childTable = db.getTable(fk.getChildTableName())).getRowCount() == 0) continue;
            throw new AxionException("Child table exist, can't truncate");
        }
    }
}

