/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.constraints;

import java.util.Iterator;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.constraints.BaseSelectableBasedConstraint;
import org.axiondb.event.RowEvent;

public class NotNullConstraint
extends BaseSelectableBasedConstraint {
    private static final long serialVersionUID = -5339792357598429782L;

    public NotNullConstraint() {
        super(null, "NOT NULL");
    }

    public NotNullConstraint(String name) {
        super(name, "NOT NULL");
    }

    public boolean evaluate(RowEvent event) throws AxionException {
        return this.evaluate(event, event.getTable().makeRowDecorator());
    }

    public boolean evaluate(RowEvent event, RowDecorator dec) throws AxionException {
        Row row = event.getNewRow();
        if (null == row) {
            return true;
        }
        return NotNullConstraint.noneNull(dec, row, this.getSelectables());
    }

    protected static boolean noneNull(RowDecorator dec, Row row, Iterator selectables) throws AxionException {
        dec.setRow(row);
        while (selectables.hasNext()) {
            Object value = ((Selectable)selectables.next()).evaluate(dec);
            if (null != value) continue;
            return false;
        }
        return true;
    }

    public boolean evaluate(RowIterator oldRows, RowIterator newRows, Table table) throws AxionException {
        if (null == newRows || newRows.isEmpty()) {
            return true;
        }
        return NotNullConstraint.noneNull(newRows, table, this.getSelectables());
    }

    protected static boolean noneNull(RowIterator newRows, Table table, Iterator selectables) throws AxionException {
        RowDecorator dec = table.makeRowDecorator();
        newRows.reset();
        while (newRows.hasNext()) {
            if (NotNullConstraint.noneNull(dec, newRows.next(), selectables)) continue;
            return false;
        }
        return true;
    }
}

