/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.SimpleTcpEndpoint;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.TcpEndpointConnector;

public class SimpleTcpConnector
extends TcpEndpointConnector
implements ServerConnector {
    public static final String VHOST_PORT = "vhost_port";
    public static final String VHOST_NAME = "vhost_name";
    public static final String SERVER = "server";
    public static final String VHOST_ADDRESS = "vhost_address";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String PORT = "port";
    public static final String INET = "inet";
    public static final String HANDLER = "handler";
    String handlerClassName;
    SimpleTcpEndpoint ep = new SimpleTcpEndpoint();
    TcpConnectionHandler con;
    ContextManager cm;
    private InetAddress address;
    private int port;
    int vport;
    private ServerSocketFactory socketFactory;
    private ServerSocket serverSocket;
    boolean running = true;

    public Object getAttribute(String prop) {
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public TcpConnectionHandler getTcpConnectionHandler() {
        return this.con;
    }

    public void setAttribute(String prop, Object value) {
        if (!VHOST_NAME.equals(prop)) {
            if (VHOST_PORT.equals(prop)) {
                this.vport = (Integer)value;
            } else if (VHOST_ADDRESS.equals(prop)) {
                this.address = (InetAddress)value;
            } else if (!SERVER.equals(prop) && SOCKET_FACTORY.equals(prop)) {
                this.socketFactory = (ServerSocketFactory)value;
            }
        }
    }

    public void setContextManager(ContextManager ctx) {
        this.cm = ctx;
    }

    public void setLogger(Logger l) {
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPort(String portS) {
        this.port = this.string2Int(portS);
    }

    public void setProperty(String prop, String value) {
        block5: {
            block6: {
                block4: {
                    if (!PORT.equals(prop)) break block4;
                    this.setPort(value);
                    break block5;
                }
                if (!HANDLER.equals(prop)) break block6;
                try {
                    Class<?> chC = Class.forName(value);
                    this.con = (TcpConnectionHandler)chC.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break block5;
            }
            if (!INET.equals(prop)) break block5;
            try {
                this.address = InetAddress.getByName(value);
            }
            catch (Exception exception) {}
        }
    }

    public void setServer(Object ctx) {
        this.cm = (ContextManager)ctx;
    }

    public void setTcpConnectionHandler(TcpConnectionHandler handler) {
        this.con = handler;
    }

    public void start() throws Exception {
        if (this.con == null) {
            throw new Exception("Invalid ConnectionHandler");
        }
        this.con.setAttribute("context.manager", this.cm);
        this.ep.setPort(this.port);
        this.ep.setAddress(this.address);
        if (this.socketFactory != null) {
            this.ep.setServerSocketFactory(this.socketFactory);
        }
        this.ep.setConnectionHandler(this.con);
        this.ep.startEndpoint();
        this.cm.log("Starting endpoint port=\"" + this.port + "\" handler=\"" + this.con.getClass().getName() + "\" ");
    }

    public void stop() throws Exception {
        this.cm.log("Stoping endpoint port=\"" + this.port + "\" handler=\"" + this.con.getClass().getName() + "\" ");
        this.ep.stopEndpoint();
    }

    private int string2Int(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

