/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.core.TomcatException;

public class ServletWrapper
extends Handler {
    protected String servletName;
    protected String servletClassName;
    protected Class servletClass;
    protected Servlet servlet;
    protected ServletConfig configF;
    private String path = null;
    protected String description = null;
    Exception unavailable = null;
    long unavailableTime = -1L;
    protected boolean isReloadable = false;
    protected long lastAccessed;
    protected int serviceCount = 0;
    boolean loadOnStartup = false;
    int loadOnStartupLevel = -1;
    Hashtable securityRoleRefs = new Hashtable();

    public void addSecurityMapping(String name, String role, String description) {
        this.securityRoleRefs.put(name, role);
    }

    protected void doDestroy() throws TomcatException {
        ServletWrapper servletWrapper = this;
        synchronized (servletWrapper) {
            while (this.serviceCount > 0) {
                try {
                    this.wait(30000L);
                    break;
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                if (this.servlet != null) {
                    this.servlet.destroy();
                }
            }
            catch (Exception ex) {
                this.context.log("Error in destroy ", ex);
            }
        }
    }

    protected void doInit() throws Exception {
        try {
            ServletWrapper servletWrapper = this;
            synchronized (servletWrapper) {
                if (this.initialized) {
                    Object var2_4 = null;
                    return;
                }
                Servlet sinstance = this.servlet;
                ServletConfig servletConfig = this.configF;
                this.servlet.init(servletConfig);
                this.initialized = true;
            }
        }
        catch (UnavailableException ex) {
            this.unavailable = ex;
            this.unavailableTime = System.currentTimeMillis();
            this.unavailableTime += (long)(ex.getUnavailableSeconds() * 1000);
            this.servlet = null;
            throw ex;
        }
        catch (Exception ex) {
            this.unavailable = ex;
            this.servlet = null;
            throw ex;
        }
    }

    protected void doService(Request req, Response res) throws Exception {
        if (this.servlet instanceof SingleThreadModel) {
            Servlet servlet = this.servlet;
            synchronized (servlet) {
                this.servlet.service((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
            }
        } else {
            this.servlet.service((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
        }
    }

    public boolean getLoadOnStartUp() {
        return this.loadOnStartup;
    }

    public int getLoadOnStartUpLevel() {
        return this.loadOnStartupLevel;
    }

    public String getPath() {
        return this.path;
    }

    public String getSecurityRole(String name) {
        return (String)this.securityRoleRefs.get(name);
    }

    public Servlet getServlet() {
        block2: {
            if (this.servlet != null) break block2;
            try {
                this.loadServlet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.servlet;
    }

    public String getServletClass() {
        return this.servletClassName;
    }

    public String getServletDescription() {
        return this.description;
    }

    public String getServletName() {
        if (this.name != null) {
            return this.name;
        }
        return this.path;
    }

    void handleJspInit() {
        ServletWrapper jspServletW = this.context.getServletByName("jsp");
        this.servletClassName = jspServletW.getServletClass();
    }

    void handleReload(Request req) throws TomcatException {
        ServletLoader loader;
        if (this.isReloadable && (loader = this.context.getServletLoader()) != null && loader.shouldReload()) {
            try {
                this.destroy();
            }
            catch (Exception ex) {
                this.context.log("Error in destroy ", ex);
            }
            this.initialized = false;
            loader.reload();
            ContextManager cm = this.context.getContextManager();
            cm.doReload(req, this.context);
            this.servlet = null;
            this.servletClass = null;
        }
    }

    public void init() throws Exception {
        if (this.servlet == null && this.path != null && this.servletClassName == null) {
            this.handleJspInit();
        }
        if (this.servlet == null) {
            this.loadServlet();
        }
        super.init();
    }

    private void loadServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.servletClass == null) {
            if (this.servletClassName == null) {
                throw new IllegalStateException("Can't happen - classname is null, who added this ?");
            }
            ServletLoader loader = this.context.getServletLoader();
            this.servletClass = loader.loadClass(this.servletClassName);
        }
        this.servlet = (Servlet)this.servletClass.newInstance();
        if (!this.servletClassName.startsWith("org.apache.tomcat")) {
            return;
        }
    }

    public void service(Request req, Response res) throws IOException, ServletException {
        try {
            this.handleReload(req);
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
        }
        if (this.path != null) {
            if (this.path.startsWith("/")) {
                req.setAttribute("javax.servlet.include.request_uri", String.valueOf(req.getContext().getPath()) + this.path);
            } else {
                req.setAttribute("javax.servlet.include.request_uri", String.valueOf(req.getContext().getPath()) + "/" + this.path);
            }
            req.setAttribute("javax.servlet.include.servlet_path", this.path);
        }
        if (this.unavailable != null) {
            this.servletAvailable();
        }
        try {
            super.service(req, res);
        }
        catch (IOException e) {
            throw ex;
        }
        catch (UnavailableException e) {
            if (this.unavailable == null) {
                ServletWrapper servletWrapper = this;
                synchronized (servletWrapper) {
                    if (this.unavailable == null) {
                        this.unavailable = e;
                        this.unavailableTime = System.currentTimeMillis();
                        this.unavailableTime += (long)(e.getUnavailableSeconds() * 1000);
                    }
                }
            }
            throw ex;
        }
        catch (ServletException e) {
            throw ex;
        }
    }

    private void servletAvailable() throws IOException, ServletException {
        if (this.unavailable instanceof UnavailableException && ((UnavailableException)((Object)this.unavailable)).isPermanent()) {
            throw (UnavailableException)((Object)this.unavailable);
        }
        long moreWaitTime = this.unavailableTime - System.currentTimeMillis();
        if (moreWaitTime > 0L) {
            int secs = (int)((moreWaitTime + 999L) / 1000L);
            throw new UnavailableException(this.unavailable.getMessage(), secs);
        }
        this.unavailable = null;
        this.unavailableTime = -1L;
        this.context.log(String.valueOf(this.getServletName()) + " unavailable time expired," + " try again ");
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.isReloadable = context.getReloadable();
        this.configF = context.getFacadeManager().createServletConfig(this);
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public void setLoadOnStartUp(int level) {
        this.loadOnStartupLevel = level;
        this.loadOnStartup = true;
    }

    public void setLoadOnStartUp(String level) {
        if (level.length() > 0) {
            this.loadOnStartupLevel = new Integer(level);
        }
        this.loadOnStartup = true;
    }

    public void setPath(String path) {
        this.path = path;
    }

    void setReloadable(boolean reloadable) {
        this.isReloadable = reloadable;
    }

    public void setServletClass(String servletClassName) {
        if (this.name == null) {
            this.name = servletClassName;
        }
        this.servletClassName = servletClassName;
        this.servlet = null;
        this.servletClass = null;
        this.initialized = false;
    }

    public void setServletDescription(String description) {
        this.description = description;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
        this.name = servletName;
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + this.servletClassName + "/" + this.path + ")";
    }
}

