/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class Resolver {
    private File file;
    private URI uri;
    private InputStream is;

    public Resolver(String path) throws IOException {
        this("", path);
    }

    public Resolver(String baseUriStr, String uriStr) throws IOException {
        if (uriStr.startsWith("classpath:")) {
            this.tryClasspath(uriStr);
        } else {
            this.tryFileSystem(baseUriStr, uriStr);
        }
        if (this.is == null) {
            String msg = "Could not find resource '" + uriStr;
            if (baseUriStr != null) {
                msg = msg + "' relative to '" + baseUriStr + "'";
            }
            throw new IOException(msg);
        }
    }

    private void tryFileSystem(String baseUriStr, String uriStr) throws IOException, MalformedURLException {
        try {
            File uriFile = new File(uriStr);
            uriFile = new File(uriFile.getAbsolutePath());
            URI relative = uriFile.exists() ? uriFile.toURI() : new URI(uriStr);
            if (relative.isAbsolute()) {
                this.uri = relative;
                this.is = relative.toURL().openStream();
            } else if (baseUriStr != null) {
                File baseFile = new File(baseUriStr);
                if (!baseFile.exists() && baseUriStr.startsWith("file:/")) {
                    baseFile = new File(baseUriStr.substring(6));
                }
                URI base = baseFile.exists() ? baseFile.toURI() : new URI(baseUriStr);
                if ((base = base.resolve(relative)).isAbsolute()) {
                    this.is = base.toURL().openStream();
                    this.uri = base;
                }
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            this.file = new File(this.uri);
        }
        if (this.is == null && this.file != null && this.file.exists()) {
            this.uri = this.file.toURI();
            try {
                this.is = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new XFireRuntimeException("File was deleted! " + uriStr, e);
            }
        } else if (this.is == null) {
            this.tryClasspath(uriStr);
        }
    }

    private void tryClasspath(String uriStr) throws IOException {
        URL url;
        if (uriStr.startsWith("classpath:")) {
            uriStr = uriStr.substring(10);
        }
        if ((url = ClassLoaderUtils.getResource(uriStr, this.getClass())) == null) {
            this.tryRemote(uriStr);
        } else {
            try {
                this.uri = new URI(url.toString());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            this.is = url.openStream();
        }
    }

    private void tryRemote(String uriStr) throws IOException {
        try {
            URL url = new URL(uriStr);
            this.uri = new URI(url.toString());
            this.is = url.openStream();
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public boolean isFile() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }
}

