/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.ArrayList;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tree;

public class GraphLib {
    public static final String LABEL = "label";
    public static final Schema LABEL_SCHEMA = new Schema();

    private GraphLib() {
    }

    public static Graph getNodes(int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        for (int i = 0; i < n; ++i) {
            Node node = g.addNode();
            node.setString(LABEL, String.valueOf(i));
        }
        return g;
    }

    public static Graph getStar(int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = g.addNode();
        r.setString(LABEL, "0");
        for (int i = 1; i <= n; ++i) {
            Node nn = g.addNode();
            nn.setString(LABEL, String.valueOf(i));
            g.addEdge(r, nn);
        }
        return g;
    }

    public static Graph getClique(int n) {
        int i;
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodes = new Node[n];
        for (i = 0; i < n; ++i) {
            nodes[i] = g.addNode();
            nodes[i].setString(LABEL, String.valueOf(i));
        }
        for (i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (i == j) continue;
                g.addEdge(nodes[i], nodes[j]);
            }
        }
        return g;
    }

    public static Graph getGrid(int m, int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodes = new Node[m * n];
        for (int i = 0; i < m * n; ++i) {
            nodes[i] = g.addNode();
            nodes[i].setString(LABEL, String.valueOf(i));
            if (i >= n) {
                g.addEdge(nodes[i - n], nodes[i]);
            }
            if (i % n == 0) continue;
            g.addEdge(nodes[i - 1], nodes[i]);
        }
        return g;
    }

    public static Graph getHoneycomb(int levels) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        ArrayList layer1 = GraphLib.halfcomb(g, levels);
        ArrayList layer2 = GraphLib.halfcomb(g, levels);
        for (int i = 0; i < levels << 1; ++i) {
            Node n1 = (Node)layer1.get(i);
            Node n2 = (Node)layer2.get(i);
            g.addEdge(n1, n2);
        }
        return g;
    }

    private static ArrayList halfcomb(Graph g, int levels) {
        Node n;
        int i;
        ArrayList<Node> top = new ArrayList<Node>();
        ArrayList<Node> layer = new ArrayList<Node>();
        int label = 0;
        for (i = 0; i < levels; ++i) {
            n = g.addNode();
            n.setString(LABEL, String.valueOf(label++));
            top.add(n);
        }
        for (i = 0; i < levels; ++i) {
            Node p;
            int j;
            n = null;
            for (j = 0; j < top.size(); ++j) {
                p = (Node)top.get(j);
                if (n == null) {
                    n = g.addNode();
                    n.setString(LABEL, String.valueOf(label++));
                    layer.add(n);
                }
                g.addEdge(p, n);
                n = g.addNode();
                n.setString(LABEL, String.valueOf(label++));
                layer.add(n);
                g.addEdge(p, n);
            }
            if (i == levels - 1) {
                return layer;
            }
            top.clear();
            for (j = 0; j < layer.size(); ++j) {
                p = (Node)layer.get(j);
                n = g.addNode();
                n.setString(LABEL, String.valueOf(label++));
                top.add(n);
                g.addEdge(p, n);
            }
            layer.clear();
        }
        return top;
    }

    public static Tree getBalancedTree(int breadth, int depth) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        if (depth > 0) {
            GraphLib.balancedHelper(t, r, breadth, depth - 1);
        }
        return t;
    }

    private static void balancedHelper(Tree t, Node n, int breadth, int depth) {
        for (int i = 0; i < breadth; ++i) {
            Node c = t.addChild(n);
            c.setString(LABEL, i + "," + c.getDepth());
            if (depth <= 0) continue;
            GraphLib.balancedHelper(t, c, breadth, depth - 1);
        }
    }

    public static Tree getLeftDeepTree(int depth) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        GraphLib.deepHelper(t, r, 2, depth, true);
        return t;
    }

    public static Tree getRightDeepTree(int depth) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        GraphLib.deepHelper(t, r, 2, depth, false);
        return t;
    }

    public static Tree getDiamondTree(int b, int d1, int d2) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        Node left = t.addChild(r);
        left.setString(LABEL, "1,0");
        Node right = t.addChild(r);
        right.setString(LABEL, "1,1");
        GraphLib.deepHelper(t, left, b, d1 - 2, true);
        GraphLib.deepHelper(t, right, b, d1 - 2, false);
        while (left.getFirstChild() != null) {
            left = left.getFirstChild();
        }
        while (right.getLastChild() != null) {
            right = right.getLastChild();
        }
        GraphLib.deepHelper(t, left, b, d2 - 1, false);
        GraphLib.deepHelper(t, right, b, d2 - 1, true);
        return t;
    }

    private static void deepHelper(Tree t, Node n, int breadth, int depth, boolean left) {
        Node c = t.addChild(n);
        c.setString(LABEL, "0," + c.getDepth());
        if (left && depth > 0) {
            GraphLib.deepHelper(t, c, breadth, depth - 1, left);
        }
        for (int i = 1; i < breadth; ++i) {
            c = t.addChild(n);
            c.setString(LABEL, i + "," + c.getDepth());
        }
        if (!left && depth > 0) {
            GraphLib.deepHelper(t, c, breadth, depth - 1, left);
        }
    }

    static {
        LABEL_SCHEMA.addColumn(LABEL, String.class, "");
    }
}

