/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;

public class FilterIterator
implements Iterator {
    private Predicate predicate;
    private Iterator tuples;
    private Tuple next;

    public FilterIterator(Iterator tuples, Predicate p) {
        this.predicate = p;
        this.tuples = tuples;
        this.next = this.advance();
    }

    private Tuple advance() {
        while (this.tuples.hasNext()) {
            Tuple t = (Tuple)this.tuples.next();
            if (!this.predicate.getBoolean(t)) continue;
            return t;
        }
        this.tuples = null;
        this.next = null;
        return null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Tuple retval = this.next;
        this.next = this.advance();
        return retval;
    }

    public boolean hasNext() {
        return this.tuples != null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

