/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.util.logging.Logger;
import prefuse.data.Table;
import prefuse.data.io.DataIOException;
import prefuse.data.io.sql.DatabaseDataSource;
import prefuse.util.PrefuseConfig;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;

public class DataSourceWorker
extends Thread {
    private static Logger s_logger = Logger.getLogger(DataSourceWorker.class.getName());
    private static DataSourceWorker s_instance;
    private static CopyOnWriteArrayList s_queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void submit(Entry e) {
        if (s_queue == null) {
            s_queue = new CopyOnWriteArrayList();
        }
        if (s_instance == null) {
            s_instance = new DataSourceWorker();
        }
        s_queue.add(e);
        DataSourceWorker dataSourceWorker = s_instance;
        synchronized (dataSourceWorker) {
            s_instance.notify();
        }
    }

    private DataSourceWorker() {
        super("prefuse_DatabaseWorker");
        int priority = PrefuseConfig.getInt("data.io.worker.threadPriority");
        if (priority >= 1 && priority <= 10) {
            this.setPriority(priority);
        }
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Entry e = null;
            CopyOnWriteArrayList copyOnWriteArrayList = s_queue;
            synchronized (copyOnWriteArrayList) {
                if (s_queue.size() > 0) {
                    e = (Entry)s_queue.remove(0);
                }
            }
            if (e != null) {
                try {
                    if (e.listener != null) {
                        e.listener.preQuery(e);
                    }
                    e.ds.getData(e.table, e.query, e.keyField, e.lock);
                    if (e.listener == null) continue;
                    e.listener.postQuery(e);
                }
                catch (DataIOException dre) {
                    s_logger.warning(dre.getMessage() + "\n" + StringLib.getStackTrace(dre));
                }
                continue;
            }
            try {
                DataSourceWorker dre = this;
                synchronized (dre) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static interface Listener {
        public void preQuery(Entry var1);

        public void postQuery(Entry var1);
    }

    public static class Entry {
        DatabaseDataSource ds;
        Listener listener;
        Table table;
        String query;
        String keyField;
        Object lock;

        public Entry(DatabaseDataSource ds, Table table, String query, String keyField, Object lock, Listener listener) {
            this.ds = ds;
            this.table = table;
            this.query = query;
            this.keyField = keyField;
            this.lock = lock;
            this.listener = listener;
        }
    }
}

