/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Literal;
import prefuse.util.TypeLib;

public class NumericLiteral
extends Literal {
    private final Number m_number;
    private final Class m_type;

    public NumericLiteral(int x) {
        this.m_number = new Integer(x);
        this.m_type = Integer.TYPE;
    }

    public NumericLiteral(long x) {
        this.m_number = new Long(x);
        this.m_type = Long.TYPE;
    }

    public NumericLiteral(float x) {
        this.m_number = new Float(x);
        this.m_type = Float.TYPE;
    }

    public NumericLiteral(double x) {
        this.m_number = new Double(x);
        this.m_type = Double.TYPE;
    }

    public NumericLiteral(Object x) {
        if (!(x instanceof Number)) {
            throw new IllegalArgumentException("Invalid type!");
        }
        this.m_number = (Number)x;
        this.m_type = TypeLib.getPrimitiveType(this.m_number.getClass());
    }

    public Class getType(Schema s) {
        return this.m_type;
    }

    public Object get(Tuple t) {
        return this.m_number;
    }

    public int getInt(Tuple t) {
        return this.m_number.intValue();
    }

    public long getLong(Tuple t) {
        return this.m_number.longValue();
    }

    public float getFloat(Tuple t) {
        return this.m_number.floatValue();
    }

    public double getDouble(Tuple t) {
        return this.m_number.doubleValue();
    }

    public String toString() {
        return this.m_number.toString();
    }
}

