/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.UnmappableCharacterException;

public class ISOLatin1ReaderInputStream
extends InputStream {
    private final Reader mReader;
    private final char[] mBuf = new char[1024];

    public ISOLatin1ReaderInputStream(Reader reader) {
        this.mReader = reader;
    }

    public int available() throws IOException {
        if (this.mReader.ready()) {
            return 1;
        }
        return 0;
    }

    public void close() throws IOException {
        this.mReader.close();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported.");
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int left;
        int got;
        char[] buf = this.mBuf;
        if (len < buf.length) {
            int got2 = this.mReader.read(buf, 0, len);
            for (int i = 0; i < got2; ++i) {
                if (buf[i] < '\u0000' || buf[i] > '\u00ff') {
                    throw new UnmappableCharacterException(1);
                }
                b[i + off] = (byte)(0xFF & buf[i]);
            }
            return got2;
        }
        boolean eof = false;
        for (left = len; left > 0; left -= got) {
            int readsofar = len - left;
            got = this.mReader.read(buf, 0, left > buf.length ? buf.length : left);
            for (int i = 0; i < got; ++i) {
                if (buf[i] < '\u0000' || buf[i] > '\u00ff') {
                    throw new UnmappableCharacterException(1);
                }
                b[i + readsofar] = (byte)(0xFF & buf[i]);
            }
            if (got >= 0) {
                continue;
            }
            eof = true;
            break;
        }
        if (eof && len == left) {
            return -1;
        }
        return len - left;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported.");
    }

    public long skip(long n) throws IOException {
        return this.mReader.skip(n);
    }

    public int read() throws IOException {
        int c = this.mReader.read();
        if (c < 0 || c > 255) {
            throw new UnmappableCharacterException(1);
        }
        return c;
    }
}

